/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.resource;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.resource.Resource;
import org.jetlinks.community.resource.ResourceManager;
import org.jetlinks.community.resource.ResourceProvider;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultResourceManager
implements ResourceManager {
    private final Map<String, ResourceProvider> providers = new ConcurrentHashMap<String, ResourceProvider>();

    public void addProvider(ResourceProvider provider) {
        this.providers.put(provider.getType(), provider);
    }

    @Override
    public Flux<Resource> getResources(String type) {
        return this.getResources(type, null);
    }

    @Override
    public Flux<Resource> getResources(String type, Collection<String> id) {
        return this.getProvider(type).flatMapMany(provider -> CollectionUtils.isEmpty((Collection)id) ? provider.getResources() : provider.getResources(id));
    }

    private Mono<ResourceProvider> getProvider(String type) {
        return Mono.justOrEmpty((Object)this.providers.get(type));
    }
}

