/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.reactorql;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetlinks.community.reactorql.EnableReactorQL;
import org.jetlinks.community.reactorql.ReactorQLFactoryBean;
import org.jetlinks.community.reactorql.ReactorQLOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.index.CandidateComponentsIndex;
import org.springframework.context.index.CandidateComponentsIndexLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class ReactorQLBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ReactorQLBeanDefinitionRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, @Nonnull BeanDefinitionRegistry registry) {
        Map attr = importingClassMetadata.getAnnotationAttributes(EnableReactorQL.class.getName());
        if (attr == null) {
            return;
        }
        String[] packages = (String[])attr.get("value");
        CandidateComponentsIndex index = CandidateComponentsIndexLoader.loadIndex((ClassLoader)ClassUtils.getDefaultClassLoader());
        if (null == index) {
            return;
        }
        Set path = Arrays.stream(packages).flatMap(str -> index.getCandidateTypes(str, ReactorQLOperation.class.getName()).stream()).collect(Collectors.toSet());
        for (String className : path) {
            Class type = ClassUtils.forName((String)className, null);
            if (!type.isInterface() || type.getAnnotation(ReactorQLOperation.class) == null) continue;
            RootBeanDefinition definition = new RootBeanDefinition();
            definition.setTargetType(type);
            definition.setBeanClass(ReactorQLFactoryBean.class);
            definition.setAutowireMode(2);
            definition.getPropertyValues().add("target", (Object)type);
            if (registry.containsBeanDefinition(type.getName())) continue;
            log.debug("register ReactorQL Operator {}", (Object)type);
            registry.registerBeanDefinition(type.getName(), (BeanDefinition)definition);
        }
    }
}

