/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.codec;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jetlinks.community.codec.ObjectSerializer;
import org.nustaq.serialization.FSTConfiguration;

public class Serializers {
    private static final ObjectSerializer JDK = new ObjectSerializer(){

        @Override
        public ObjectInput createInput(InputStream stream) {
            return new ObjectInputStream(stream);
        }

        @Override
        public ObjectOutput createOutput(OutputStream stream) {
            return new ObjectOutputStream(stream);
        }
    };
    private static final ObjectSerializer FST = new ObjectSerializer(){
        final FastThreadLocal<FSTConfiguration> conf = new FastThreadLocal<FSTConfiguration>(){

            protected FSTConfiguration initialValue() {
                FSTConfiguration configuration = FSTConfiguration.createDefaultConfiguration();
                configuration.setForceSerializable(true);
                configuration.setClassLoader(FST.getClass().getClassLoader());
                return configuration;
            }
        };

        @Override
        public ObjectInput createInput(InputStream stream) {
            return ((FSTConfiguration)this.conf.get()).getObjectInput(stream);
        }

        @Override
        public ObjectOutput createOutput(OutputStream stream) {
            return ((FSTConfiguration)this.conf.get()).getObjectOutput(stream);
        }
    };
    private static final ObjectSerializer DEFAULT = System.getProperty("jetlinks.object.serializer.type", "fst").equals("fst") ? FST : JDK;

    public static ObjectSerializer jdk() {
        return JDK;
    }

    public static ObjectSerializer fst() {
        return FST;
    }

    public static ObjectSerializer getDefault() {
        return DEFAULT;
    }
}

