/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.utils.ConverterUtils;
import org.springframework.util.StringUtils;

public class PropertyMetric {
    @Schema(description="\u6307\u6807ID")
    @NotBlank
    private String id;
    @Schema(description="\u540d\u79f0")
    @NotBlank
    private String name;
    @Schema(description="\u503c,\u8303\u56f4\u503c\u4f7f\u7528\u9017\u53f7\u5206\u9694")
    private Object value;
    @Schema(description="\u662f\u5426\u4e3a\u8303\u56f4\u503c")
    private boolean range;
    @Schema(description="\u5176\u4ed6\u62d3\u5c55\u914d\u7f6e")
    private Map<String, Object> expands;

    public Object castValue() {
        if (this.value == null) {
            return null;
        }
        if (this.range) {
            return ConverterUtils.tryConvertToList(this.value, Function.identity());
        }
        return this.value;
    }

    public PropertyMetric merge(PropertyMetric another) {
        if (!StringUtils.hasText((String)this.name)) {
            this.setValue(another.value);
        }
        return this;
    }

    public static PropertyMetric of(String id, String name, Object value) {
        PropertyMetric metric = new PropertyMetric();
        metric.setId(id);
        metric.setName(name);
        metric.setValue(value);
        return metric;
    }

    public static PropertyMetric of(Object mapMetric) {
        return (PropertyMetric)FastBeanCopier.copy((Object)mapMetric, (Object)new PropertyMetric(), (String[])new String[0]);
    }

    public static PropertyMetricBuilder builder() {
        return new PropertyMetricBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isRange() {
        return this.range;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setRange(boolean range) {
        this.range = range;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    public PropertyMetric() {
    }

    public PropertyMetric(String id, String name, Object value, boolean range, Map<String, Object> expands) {
        this.id = id;
        this.name = name;
        this.value = value;
        this.range = range;
        this.expands = expands;
    }

    public static class PropertyMetricBuilder {
        private String id;
        private String name;
        private Object value;
        private boolean range;
        private Map<String, Object> expands;

        PropertyMetricBuilder() {
        }

        public PropertyMetricBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PropertyMetricBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PropertyMetricBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public PropertyMetricBuilder range(boolean range) {
            this.range = range;
            return this;
        }

        public PropertyMetricBuilder expands(Map<String, Object> expands) {
            this.expands = expands;
            return this;
        }

        public PropertyMetric build() {
            return new PropertyMetric(this.id, this.name, this.value, this.range, this.expands);
        }

        public String toString() {
            return "PropertyMetric.PropertyMetricBuilder(id=" + this.id + ", name=" + this.name + ", value=" + this.value + ", range=" + this.range + ", expands=" + this.expands + ")";
        }
    }
}

