/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.timeseries.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesMetric;
import org.jetlinks.community.timeseries.micrometer.MeterTimeSeriesData;
import org.jetlinks.community.timeseries.micrometer.MeterTimeSeriesMetadata;
import org.jetlinks.community.timeseries.micrometer.TimeSeriesPropertiesPropertiesConfigAdapter;
import org.jetlinks.community.timeseries.micrometer.TimeSeriesRegistryProperties;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TimeSeriesMeterRegistry
extends StepMeterRegistry {
    private static final Logger log = LoggerFactory.getLogger(TimeSeriesMeterRegistry.class);
    TimeSeriesManager timeSeriesManager;
    TimeSeriesMetric metric;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("time-series-metrics-publisher");
    private Map<String, String> customTags;
    private List<String> keys = new ArrayList<String>();

    public TimeSeriesMeterRegistry(TimeSeriesManager timeSeriesManager, TimeSeriesMetric metric, TimeSeriesRegistryProperties config, Map<String, String> customTags, String ... tagKeys) {
        super((StepRegistryConfig)new TimeSeriesPropertiesPropertiesConfigAdapter(config), Clock.SYSTEM);
        this.timeSeriesManager = timeSeriesManager;
        this.metric = metric;
        this.customTags = customTags;
        this.keys.addAll(customTags.keySet());
        this.keys.addAll(Arrays.asList(tagKeys));
        this.keys.addAll(config.getCustomTagKeys());
        this.start(DEFAULT_THREAD_FACTORY);
    }

    public void start(ThreadFactory threadFactory) {
        super.start(threadFactory);
        this.timeSeriesManager.registerMetadata(MeterTimeSeriesMetadata.of(this.metric, this.keys)).doOnError(e -> log.error("register metric [{}] metadata error", (Object)this.metric.getId(), e)).subscribe(r -> log.error("register metric [{}] metadata success", (Object)this.metric.getId()));
    }

    protected void publish() {
        this.timeSeriesManager.getService(this.metric).save((Publisher<TimeSeriesData>)Flux.fromIterable((Iterable)this.getMeters()).map(meter -> MeterTimeSeriesData.of(meter).name(this.getConventionName(meter.getId())).write(this.customTags).write(this.getConventionTags(meter.getId())))).doOnError(e -> log.error("failed to send metrics [{}]", (Object)this.metric.getId(), e)).doOnSuccess(nil -> log.debug("success send metrics [{}]", (Object)this.metric.getId())).subscribe();
    }

    @Nonnull
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }
}

