/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.timeseries.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetlinks.community.timeseries.TimeSeriesData;

public class MeterTimeSeriesData
implements TimeSeriesData {
    private Map<String, Object> data = new HashMap<String, Object>();
    private long timestamp = System.currentTimeMillis();

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    public MeterTimeSeriesData name(String name) {
        this.data.put("name", name);
        return this;
    }

    public MeterTimeSeriesData write(Map<String, String> tags) {
        if (tags != null) {
            this.data.putAll(tags);
        }
        return this;
    }

    public MeterTimeSeriesData write(List<Tag> tags) {
        for (Tag tag : tags) {
            this.data.put(tag.getKey(), tag.getValue());
        }
        return this;
    }

    public MeterTimeSeriesData write(Counter counter) {
        double value = counter.count();
        if (Double.isFinite(value)) {
            this.data.put("count", value);
        }
        return this;
    }

    public MeterTimeSeriesData write(Gauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            this.data.put("value", value);
        }
        return this;
    }

    public MeterTimeSeriesData write(TimeGauge gauge) {
        double value = gauge.value(TimeUnit.MILLISECONDS);
        if (Double.isFinite(value)) {
            this.data.put("value", value);
        }
        return this;
    }

    public MeterTimeSeriesData write(FunctionTimer timer) {
        this.data.put("count", timer.count());
        this.data.put("sum", timer.totalTime(TimeUnit.MILLISECONDS));
        this.data.put("mean", timer.mean(TimeUnit.MILLISECONDS));
        return this;
    }

    public MeterTimeSeriesData write(LongTaskTimer timer) {
        this.data.put("activeTasks", timer.activeTasks());
        this.data.put("duration", timer.duration(TimeUnit.MILLISECONDS));
        return this;
    }

    public MeterTimeSeriesData write(Timer timer) {
        this.data.put("count", timer.count());
        this.data.put("sum", timer.totalTime(TimeUnit.MILLISECONDS));
        this.data.put("mean", timer.mean(TimeUnit.MILLISECONDS));
        this.data.put("max", timer.max(TimeUnit.MILLISECONDS));
        return this;
    }

    public MeterTimeSeriesData write(DistributionSummary summary) {
        this.data.put("count", summary.count());
        this.data.put("sum", summary.totalAmount());
        this.data.put("mean", summary.mean());
        this.data.put("max", summary.max());
        return this;
    }

    public MeterTimeSeriesData write(Meter meter) {
        String type = meter.getId().getType().toString().toLowerCase();
        this.data.put("type", type);
        return this;
    }

    public static MeterTimeSeriesData of(Meter meter) {
        MeterTimeSeriesData data = new MeterTimeSeriesData();
        data.write(meter);
        meter.match(data::write, data::write, data::write, data::write, data::write, data::write, data::write, data::write, data::write);
        return data;
    }
}

