/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.things.data.AggregationRequest;
import org.jetlinks.community.things.data.ThingProperties;
import org.jetlinks.community.things.data.ThingPropertyDetail;
import org.jetlinks.community.things.data.operations.AbstractQueryOperations;
import org.jetlinks.community.things.data.operations.ColumnModeQueryOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ColumnModeQueryOperationsBase
extends AbstractQueryOperations
implements ColumnModeQueryOperations {
    public ColumnModeQueryOperationsBase(String thingType, String thingTemplateId, String thingId, MetricBuilder metricBuilder, DataSettings settings, ThingsRegistry registry) {
        super(thingType, thingTemplateId, thingId, metricBuilder, settings, registry);
    }

    @Override
    protected final Flux<ThingPropertyDetail> queryProperty(@Nonnull QueryParamEntity param, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        return this.queryProperty(metric, param.toNestQuery(this::applyQuery), metadata, properties);
    }

    protected Flux<ThingPropertyDetail> queryProperty(@Nonnull String metric, @Nonnull Query<?, QueryParamEntity> query, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        return this.doQuery(metric, query).flatMap(data -> Flux.create(sink -> {
            for (Map.Entry entry : properties.entrySet()) {
                data.get((String)entry.getKey()).ifPresent(value -> sink.next((Object)ThingPropertyDetail.of(value, (PropertyMetadata)entry.getValue()).thingId(data.getString(this.metricBuilder.getThingIdProperty(), null)).timestamp(data.getTimestamp()).createTime(data.getLong("createTime", data.getTimestamp())).generateId()));
            }
            sink.complete();
        }));
    }

    @Override
    protected Flux<ThingPropertyDetail> queryEachProperty(@Nonnull String metric, @Nonnull Query<?, QueryParamEntity> query, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        return this.queryProperty(metric, query, metadata, properties);
    }

    @Override
    protected Mono<PagerResult<ThingPropertyDetail>> queryPropertyPage(@Nonnull QueryParamEntity param, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        if (properties.size() > 1) {
            return Mono.error((Throwable)new UnsupportedOperationException("error.unsupported_query_multi_property"));
        }
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(this::applyQuery);
        String property = properties.keySet().iterator().next();
        query.notNull(property);
        return this.doQueryPage(metric, query, data -> ThingPropertyDetail.of(data.get(property).orElse(null), (PropertyMetadata)properties.get(property)).thingId(data.getString(this.metricBuilder.getThingIdProperty(), null)).timestamp(data.getTimestamp()).createTime(data.getLong("createTime", data.getTimestamp())).generateId());
    }

    @Override
    @Nonnull
    public Mono<PagerResult<ThingProperties>> queryAllPropertiesPage(@Nonnull QueryParamEntity param) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(this::applyQuery);
        return this.doQueryPage(metric, query, data -> new ThingProperties(data.getData(), this.metricBuilder.getThingIdProperty()));
    }

    @Override
    @Nonnull
    public Flux<ThingProperties> queryAllProperties(@Nonnull QueryParamEntity param) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(this::applyQuery);
        return this.doQuery(metric, query).map(data -> new ThingProperties(data.getData(), this.metricBuilder.getThingIdProperty()));
    }

    @Override
    protected abstract Flux<TimeSeriesData> doQuery(String var1, Query<?, QueryParamEntity> var2);

    @Override
    protected abstract <T> Mono<PagerResult<T>> doQueryPage(String var1, Query<?, QueryParamEntity> var2, Function<TimeSeriesData, T> var3);

    @Override
    protected abstract Flux<AggregationData> doAggregation(String var1, AggregationRequest var2, AbstractQueryOperations.AggregationContext var3);
}

