/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.things.data.operations.DDLOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.things.ThingMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

public abstract class AbstractDDLOperations
implements DDLOperations {
    protected final String thingType;
    protected final String templateId;
    protected final String thingId;
    protected final DataSettings settings;
    protected final MetricBuilder metricBuilder;

    protected List<PropertyMetadata> createBasicColumns() {
        return Arrays.asList(SimplePropertyMetadata.of((String)"id", (String)"ID", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)this.metricBuilder.getThingIdProperty(), (String)"\u7269ID", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"messageId", (String)"\u6d88\u606fID", (DataType)StringType.GLOBAL), SimplePropertyMetadata.of((String)"createTime", (String)"\u521b\u5efa\u65f6\u95f4", (DataType)DateTimeType.GLOBAL), SimplePropertyMetadata.of((String)"timestamp", (String)"\u6570\u636e\u65f6\u95f4", (DataType)DateTimeType.GLOBAL));
    }

    protected abstract List<PropertyMetadata> createPropertyProperties(List<PropertyMetadata> var1);

    protected List<PropertyMetadata> createLogProperties() {
        ArrayList<PropertyMetadata> metadata = new ArrayList<PropertyMetadata>(this.createBasicColumns());
        metadata.add((PropertyMetadata)SimplePropertyMetadata.of((String)"type", (String)"\u65e5\u5fd7\u7c7b\u578b", (DataType)StringType.GLOBAL));
        metadata.add((PropertyMetadata)SimplePropertyMetadata.of((String)"content", (String)"\u65e5\u5fd7\u5185\u5bb9", (DataType)new StringType().expand(ConfigMetadataConstants.maxLength, (Object)4096L)));
        return metadata;
    }

    protected List<PropertyMetadata> createEventProperties(EventMetadata event) {
        ArrayList<PropertyMetadata> metadata = new ArrayList<PropertyMetadata>(this.createBasicColumns());
        DataType type = event.getType();
        if (type instanceof ObjectType) {
            if (CollectionUtils.isNotEmpty((Collection)((ObjectType)type).getProperties())) {
                metadata.addAll(((ObjectType)type).getProperties());
            }
        } else {
            metadata.add((PropertyMetadata)SimplePropertyMetadata.of((String)"value", (String)"\u4e8b\u4ef6\u6570\u636e", (DataType)type));
        }
        return metadata;
    }

    protected List<PropertyMetadata> createEventProperties() {
        ArrayList<PropertyMetadata> metadata = new ArrayList<PropertyMetadata>(this.createBasicColumns());
        metadata.add((PropertyMetadata)SimplePropertyMetadata.of((String)"value", (String)"\u4e8b\u4ef6\u6570\u636e", (DataType)StringType.GLOBAL));
        return metadata;
    }

    private Mono<Void> doWith(ThingMetadata metadata, Function3<MetricType, String, List<PropertyMetadata>, Mono<Void>> handler) {
        Mono properties = (Mono)handler.apply((Object)MetricType.properties, (Object)this.metricBuilder.createPropertyMetric(this.thingType, this.templateId, this.thingId), this.createPropertyProperties(metadata.getProperties()));
        Mono log = (Mono)handler.apply((Object)MetricType.log, (Object)this.metricBuilder.createLogMetric(this.thingType, this.templateId, this.thingId), this.createLogProperties());
        Mono event = this.settings.getEvent().eventIsAllInOne() ? (Mono)handler.apply((Object)MetricType.event, (Object)this.metricBuilder.createEventAllInOneMetric(this.thingType, this.templateId, this.thingId), this.createEventProperties()) : Flux.fromIterable((Iterable)metadata.getEvents()).flatMap(e -> (Mono)handler.apply((Object)MetricType.event, (Object)this.metricBuilder.createEventMetric(this.thingType, this.templateId, this.thingId, e.getId()), this.createEventProperties((EventMetadata)e))).then();
        return Flux.concat((Publisher[])new Publisher[]{properties, log, event}).then();
    }

    @Override
    public final Mono<Void> registerMetadata(ThingMetadata metadata) {
        return this.doWith(metadata, (Function3<MetricType, String, List<PropertyMetadata>, Mono<Void>>)((Function3)this::register));
    }

    @Override
    public final Mono<Void> reloadMetadata(ThingMetadata metadata) {
        return this.doWith(metadata, (Function3<MetricType, String, List<PropertyMetadata>, Mono<Void>>)((Function3)this::reload));
    }

    protected abstract Mono<Void> register(MetricType var1, String var2, List<PropertyMetadata> var3);

    protected abstract Mono<Void> reload(MetricType var1, String var2, List<PropertyMetadata> var3);

    public AbstractDDLOperations(String thingType, String templateId, String thingId, DataSettings settings, MetricBuilder metricBuilder) {
        this.thingType = thingType;
        this.templateId = templateId;
        this.thingId = thingId;
        this.settings = settings;
        this.metricBuilder = metricBuilder;
    }

    public static enum MetricType {
        properties,
        log,
        event;

    }
}

