/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.things.data.operations.SaveOperations;
import org.jetlinks.community.things.data.operations.TemplateOperations;
import org.jetlinks.community.things.data.operations.ThingOperations;
import org.jetlinks.core.metadata.Feature;
import org.springframework.core.Ordered;
import reactor.core.publisher.Flux;

public interface ThingsDataRepositoryStrategy
extends Ordered {
    public String getId();

    public String getName();

    public SaveOperations opsForSave(OperationsContext var1);

    public ThingOperations opsForThing(String var1, String var2, String var3, OperationsContext var4);

    public TemplateOperations opsForTemplate(String var1, String var2, OperationsContext var3);

    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    default public Flux<Feature> getFeatures() {
        return Flux.empty();
    }

    public static class OperationsContext {
        private transient int $hashCodeCache;
        public static final OperationsContext DEFAULT = new OperationsContext(MetricBuilder.DEFAULT, new DataSettings());
        private final MetricBuilder metricBuilder;
        private final DataSettings settings;

        public OperationsContext settings(DataSettings settings) {
            return new OperationsContext(this.metricBuilder, settings);
        }

        public OperationsContext metricBuilder(MetricBuilder metricBuilder) {
            return new OperationsContext(metricBuilder, this.settings);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationsContext)) {
                return false;
            }
            OperationsContext other = (OperationsContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MetricBuilder this$metricBuilder = this.getMetricBuilder();
            MetricBuilder other$metricBuilder = other.getMetricBuilder();
            if (this$metricBuilder == null ? other$metricBuilder != null : !this$metricBuilder.equals(other$metricBuilder)) {
                return false;
            }
            DataSettings this$settings = this.getSettings();
            DataSettings other$settings = other.getSettings();
            return !(this$settings == null ? other$settings != null : !this$settings.equals(other$settings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OperationsContext;
        }

        public int hashCode() {
            if (this.$hashCodeCache != 0) {
                return this.$hashCodeCache;
            }
            int PRIME = 59;
            int result = 1;
            MetricBuilder $metricBuilder = this.getMetricBuilder();
            result = result * 59 + ($metricBuilder == null ? 43 : $metricBuilder.hashCode());
            DataSettings $settings = this.getSettings();
            if ((result = result * 59 + ($settings == null ? 43 : $settings.hashCode())) == 0) {
                result = Integer.MIN_VALUE;
            }
            this.$hashCodeCache = result;
            return result;
        }

        public MetricBuilder getMetricBuilder() {
            return this.metricBuilder;
        }

        public DataSettings getSettings() {
            return this.settings;
        }

        public OperationsContext(MetricBuilder metricBuilder, DataSettings settings) {
            this.metricBuilder = metricBuilder;
            this.settings = settings;
        }
    }
}

