/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hswebframework.web.exception.I18nSupportException;
import org.jetlinks.community.things.ThingsDataRepository;
import org.jetlinks.community.things.data.ThingsDataConstants;
import org.jetlinks.community.things.data.ThingsDataContext;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategies;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategy;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.things.data.operations.SaveOperations;
import org.jetlinks.community.things.data.operations.TemplateOperations;
import org.jetlinks.community.things.data.operations.ThingOperations;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingsRegistry;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DefaultThingsDataRepository
implements ThingsDataRepository,
ThingsDataContext,
SaveOperations {
    private final Map<String, ThingsDataRepositoryStrategy> policies = new ConcurrentHashMap<String, ThingsDataRepositoryStrategy>();
    private final Map<String, ThingsDataRepositoryStrategy.OperationsContext> contexts = new ConcurrentHashMap<String, ThingsDataRepositoryStrategy.OperationsContext>();
    private final ThingsRegistry registry;
    private String defaultPolicy = "default-row";
    private ThingsDataRepositoryStrategy.OperationsContext defaultContext = new ThingsDataRepositoryStrategy.OperationsContext(MetricBuilder.DEFAULT, new DataSettings());

    public DefaultThingsDataRepository(ThingsRegistry registry) {
        this.registry = registry;
    }

    private ThingsDataRepositoryStrategy getPolicyNow(String policy) {
        ThingsDataRepositoryStrategy dataPolicy = this.policies.get(policy);
        if (dataPolicy == null) {
            throw new I18nSupportException("error.thing_data_policy_unsupported", new Object[]{policy});
        }
        return dataPolicy;
    }

    private Mono<Tuple2<String, ThingsDataRepositoryStrategy>> getPolicyByThing(String thingType, String thingId) {
        return this.registry.getThing(thingType, thingId).flatMap(thing -> Mono.zip((Mono)thing.getTemplate().map(ThingTemplate::getId), (Mono)thing.getConfig(ThingsDataConstants.storePolicyConfigKey).defaultIfEmpty((Object)this.defaultPolicy).map(this::getPolicyNow)));
    }

    private Mono<ThingsDataRepositoryStrategy> getPolicyByTemplate(String thingType, String templateId) {
        return this.registry.getTemplate(thingType, templateId).flatMap(template -> template.getConfig(ThingsDataConstants.storePolicyConfigKey).defaultIfEmpty((Object)this.defaultPolicy)).map(this::getPolicyNow);
    }

    @Override
    public SaveOperations opsForSave() {
        return this;
    }

    @Override
    public Mono<ThingOperations> opsForThing(String thingType, String thingId) {
        return this.getPolicyByThing(thingType, thingId).map(tp2 -> ((ThingsDataRepositoryStrategy)tp2.getT2()).opsForThing(thingType, (String)tp2.getT1(), thingId, this.contexts.getOrDefault(thingType, this.defaultContext)));
    }

    @Override
    public Mono<TemplateOperations> opsForTemplate(String thingType, String templateId) {
        return this.getPolicyByTemplate(thingType, templateId).map(policy -> policy.opsForTemplate(thingType, templateId, this.contexts.getOrDefault(thingType, this.defaultContext)));
    }

    @Override
    public void customMetricBuilder(String thingType, MetricBuilder metricBuilder) {
        this.contexts.compute(thingType, (k, old) -> {
            if (old == null) {
                return new ThingsDataRepositoryStrategy.OperationsContext(metricBuilder, this.defaultContext.getSettings());
            }
            return old.metricBuilder(metricBuilder);
        });
    }

    @Override
    public void customSettings(String thingType, DataSettings settings) {
        this.contexts.compute(thingType, (k, old) -> {
            if (old == null) {
                return new ThingsDataRepositoryStrategy.OperationsContext(this.defaultContext.getMetricBuilder(), settings);
            }
            return old.settings(settings);
        });
    }

    @Override
    public void setDefaultPolicy(String policy) {
        this.defaultPolicy = policy;
    }

    @Override
    public void setDefaultSettings(DataSettings settings) {
        for (Map.Entry<String, ThingsDataRepositoryStrategy.OperationsContext> entry : this.contexts.entrySet()) {
            if (entry.getValue().getSettings() != this.defaultContext.getSettings()) continue;
            entry.setValue(new ThingsDataRepositoryStrategy.OperationsContext(entry.getValue().getMetricBuilder(), settings));
        }
        this.defaultContext = new ThingsDataRepositoryStrategy.OperationsContext(MetricBuilder.DEFAULT, settings);
    }

    @Override
    public void addPolicy(ThingsDataRepositoryStrategy policy) {
        ThingsDataRepositoryStrategies.register(policy);
        this.policies.put(policy.getId(), policy);
    }

    @Override
    public Mono<Void> save(ThingMessage thingMessage) {
        return this.doSave(thingMessage.getThingType(), thingMessage.getThingId(), opt -> opt.save(thingMessage));
    }

    @Override
    public Mono<Void> save(Collection<? extends ThingMessage> thingMessage) {
        return this.save((Publisher<? extends ThingMessage>)Flux.fromIterable(thingMessage));
    }

    @Override
    public Mono<Void> save(Publisher<? extends ThingMessage> thingMessage) {
        return Flux.from(thingMessage).groupBy(msg -> Tuples.of((Object)msg.getThingType(), (Object)msg.getThingId())).flatMap(group -> this.doSave((String)((Tuple2)group.key()).getT1(), (String)((Tuple2)group.key()).getT2(), opt -> opt.save((Publisher<? extends ThingMessage>)group))).then();
    }

    private Mono<Void> doSave(String thingType, String thingId, Function<SaveOperations, Mono<Void>> opt) {
        return this.getPolicyByThing(thingType, thingId).flatMap(tp2 -> (Mono)opt.apply(((ThingsDataRepositoryStrategy)tp2.getT2()).opsForSave(this.contexts.getOrDefault(thingType, this.defaultContext))));
    }
}

