/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.things.ThingConstants;
import org.jetlinks.community.things.data.LocalFileThingsDataManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.property.PropertyMessage;
import org.jetlinks.core.things.ThingId;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.things.ThingType;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public class AutoUpdateThingsDataManager
extends LocalFileThingsDataManager {
    private final Map<ThingId, Updater> updaters = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).removalListener((key, value, cause) -> {
        if (cause == RemovalCause.EXPIRED && value != null) {
            value.dispose();
        }
    }).build().asMap();
    private final EventBus eventBus;

    public AutoUpdateThingsDataManager(String fileName, EventBus eventBus) {
        super(fileName);
        this.eventBus = eventBus;
    }

    @Override
    public Mono<List<ThingProperty>> getProperties(String thingType, String thingId, String property, long from, long to) {
        Updater updater = this.getUpdater(thingType, thingId);
        updater.tryLoad(property);
        Mono loader = updater.loader;
        if (updater.loading && loader != null) {
            return loader.then(Mono.defer(() -> super.getProperties(thingType, thingId, property, from, to)));
        }
        return super.getProperties(thingType, thingId, property, from, to);
    }

    @Override
    public Mono<ThingProperty> getLastProperty(String thingType, String thingId, String property, long baseTime) {
        Updater updater = this.getUpdater(thingType, thingId);
        updater.tryLoad(property);
        Mono loader = updater.loader;
        if (updater.loading && loader != null) {
            return loader.then(Mono.defer(() -> super.getLastProperty(thingType, thingId, property, baseTime)));
        }
        return super.getLastProperty(thingType, thingId, property, baseTime);
    }

    @Override
    public Mono<ThingProperty> getFirstProperty(String thingType, String thingId, String property) {
        Updater updater = this.getUpdater(thingType, thingId);
        updater.tryLoad(property);
        Mono loader = updater.loader;
        if (updater.loading && loader != null) {
            return loader.then(Mono.defer(() -> super.getFirstProperty(thingType, thingId, property)));
        }
        return super.getFirstProperty(thingType, thingId, property);
    }

    private Updater getUpdater(String thingType, String thingId) {
        ThingId key = ThingId.of((String)thingType, (String)thingId);
        return this.updaters.computeIfAbsent(key, this::createUpdater);
    }

    private Mono<Void> loadData(String thingType, String thingId, String property) {
        return Mono.empty();
    }

    protected Updater createUpdater(ThingId id) {
        return new Updater(id.getType(), id.getId());
    }

    private ByteBuf encodeHistory(LocalFileThingsDataManager.PropertyHistory history) {
        ByteBuf buf = Unpooled.buffer();
        try (ObjectOutput out = this.createOutput(buf);){
            history.writeExternal(out);
        }
        return buf;
    }

    private LocalFileThingsDataManager.PropertyHistory decodeHistory(ByteBuf buf) {
        LocalFileThingsDataManager.PropertyHistory history = new LocalFileThingsDataManager.PropertyHistory();
        try (ObjectInput input = this.createInput(buf);){
            history.readExternal(input);
        }
        return history;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.updaters.values().forEach(Disposable::dispose);
    }

    protected class Updater
    implements Disposable {
        private final String thingType;
        private final String thingId;
        private final Disposable disposable;
        private final Set<String> include = ConcurrentHashMap.newKeySet();
        private boolean loading;
        private Mono<Void> loader;

        public Updater(String thingType, String thingId) {
            this.thingType = thingType;
            this.thingId = thingId;
            this.disposable = AutoUpdateThingsDataManager.this.eventBus.subscribe(Subscription.builder().subscriberId("thing-data-property-updater").topics(ThingConstants.Topics.properties(ThingType.of((String)thingType), thingId)).local().broker().build(), PropertyMessage.class).doOnNext(this::doUpdate).subscribe();
        }

        private void doUpdate(PropertyMessage message) {
            try {
                Map properties = message.getProperties();
                if (properties == null) {
                    return;
                }
                for (Map.Entry entry : properties.entrySet()) {
                    String property = (String)entry.getKey();
                    if (!this.include.contains(property)) continue;
                    AutoUpdateThingsDataManager.this.updateProperty0(this.thingType, this.thingId, property, message.getPropertySourceTime(property).orElse(message.getTimestamp()), entry.getValue(), message.getPropertyState(property).orElse(null));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void tryLoad(String property) {
            if (this.include.add(property)) {
                this.loading = true;
                this.loader = AutoUpdateThingsDataManager.this.loadData(this.thingType, this.thingId, property).doAfterTerminate(() -> {
                    this.loading = false;
                    this.loader = null;
                }).cache();
            }
        }

        public void dispose() {
            this.disposable.dispose();
            this.include.clear();
        }

        public boolean isDisposed() {
            return this.disposable.isDisposed();
        }
    }

    public static class ThingHistoryRequest {
        private String thingType;
        private String thingId;
        private String property;

        public String getThingType() {
            return this.thingType;
        }

        public String getThingId() {
            return this.thingId;
        }

        public String getProperty() {
            return this.property;
        }

        public void setThingType(String thingType) {
            this.thingType = thingType;
        }

        public void setThingId(String thingId) {
            this.thingId = thingId;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        private ThingHistoryRequest(String thingType, String thingId, String property) {
            this.thingType = thingType;
            this.thingId = thingId;
            this.property = property;
        }

        public static ThingHistoryRequest of(String thingType, String thingId, String property) {
            return new ThingHistoryRequest(thingType, thingId, property);
        }

        public ThingHistoryRequest() {
        }
    }
}

