/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.utils.ConverterUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.joda.time.DateTime;

public class AggregationRequest {
    @Schema(description="\u95f4\u9694,\u5982: 1d", type="string", defaultValue="1d")
    @Nullable
    Interval interval;
    @Schema(defaultValue="\u65f6\u95f4\u683c\u5f0f,\u5982:yyyy-MM-dd", description="yyyy-MM-dd")
    String format;
    @Schema(description="\u65f6\u95f4\u4ece,\u5982: 2020-09-01 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d")
    Date from;
    @Schema(description="\u65f6\u95f4\u5230,\u5982: 2020-09-30 00:00:00,\u652f\u6301\u8868\u8fbe\u5f0f: now-1d")
    Date to;
    @Schema(description="\u6570\u91cf\u9650\u5236")
    int limit;
    @Schema(description="\u8fc7\u6ee4\u6761\u4ef6")
    QueryParamEntity filter;

    public AggregationRequest copy() {
        return new AggregationRequest(this.interval, this.format, this.from, this.to, this.limit, this.filter.clone());
    }

    @Hidden
    public void setQuery(QueryParamEntity filter) {
        this.setFilter(filter);
    }

    public void prepareTimestampCondition() {
        for (Term term : this.filter.getTerms()) {
            if (!"timestamp".equals(term.getColumn())) continue;
            if ("btw".equals(term.getTermType())) {
                List values = ConverterUtils.convertToList((Object)term.getValue());
                if (values.size() > 0) {
                    this.from = CastUtils.castDate(values.get(0));
                }
                if (values.size() > 1) {
                    this.to = CastUtils.castDate(values.get(1));
                }
                term.setValue(null);
                continue;
            }
            if ("gt".equals(term.getTermType()) || "gte".equals(term.getTermType())) {
                this.from = CastUtils.castDate((Object)term.getValue());
                term.setValue(null);
                continue;
            }
            if (!"lt".equals(term.getTermType()) && !"lte".equals(term.getTermType())) continue;
            this.to = CastUtils.castDate((Object)term.getValue());
            term.setValue(null);
        }
    }

    private static Interval $default$interval() {
        return Interval.ofDays((int)1);
    }

    private static String $default$format() {
        return "yyyy-MM-dd";
    }

    private static Date $default$from() {
        return new DateTime().plusMonths(-1).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).toDate();
    }

    private static Date $default$to() {
        return new DateTime().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).toDate();
    }

    private static int $default$limit() {
        return 30;
    }

    private static QueryParamEntity $default$filter() {
        return QueryParamEntity.of();
    }

    public static AggregationRequestBuilder builder() {
        return new AggregationRequestBuilder();
    }

    @Nullable
    public Interval getInterval() {
        return this.interval;
    }

    public String getFormat() {
        return this.format;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public int getLimit() {
        return this.limit;
    }

    public QueryParamEntity getFilter() {
        return this.filter;
    }

    public void setInterval(@Nullable Interval interval) {
        this.interval = interval;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setFilter(QueryParamEntity filter) {
        this.filter = filter;
    }

    public AggregationRequest(@Nullable Interval interval, String format, Date from, Date to, int limit, QueryParamEntity filter) {
        this.interval = interval;
        this.format = format;
        this.from = from;
        this.to = to;
        this.limit = limit;
        this.filter = filter;
    }

    public AggregationRequest() {
        this.interval = AggregationRequest.$default$interval();
        this.format = AggregationRequest.$default$format();
        this.from = AggregationRequest.$default$from();
        this.to = AggregationRequest.$default$to();
        this.limit = AggregationRequest.$default$limit();
        this.filter = AggregationRequest.$default$filter();
    }

    public static class AggregationRequestBuilder {
        private boolean interval$set;
        private Interval interval$value;
        private boolean format$set;
        private String format$value;
        private boolean from$set;
        private Date from$value;
        private boolean to$set;
        private Date to$value;
        private boolean limit$set;
        private int limit$value;
        private boolean filter$set;
        private QueryParamEntity filter$value;

        AggregationRequestBuilder() {
        }

        public AggregationRequestBuilder interval(@Nullable Interval interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return this;
        }

        public AggregationRequestBuilder format(String format) {
            this.format$value = format;
            this.format$set = true;
            return this;
        }

        public AggregationRequestBuilder from(Date from) {
            this.from$value = from;
            this.from$set = true;
            return this;
        }

        public AggregationRequestBuilder to(Date to) {
            this.to$value = to;
            this.to$set = true;
            return this;
        }

        public AggregationRequestBuilder limit(int limit) {
            this.limit$value = limit;
            this.limit$set = true;
            return this;
        }

        public AggregationRequestBuilder filter(QueryParamEntity filter) {
            this.filter$value = filter;
            this.filter$set = true;
            return this;
        }

        public AggregationRequest build() {
            Interval interval$value = this.interval$value;
            if (!this.interval$set) {
                interval$value = AggregationRequest.$default$interval();
            }
            String format$value = this.format$value;
            if (!this.format$set) {
                format$value = AggregationRequest.$default$format();
            }
            Date from$value = this.from$value;
            if (!this.from$set) {
                from$value = AggregationRequest.$default$from();
            }
            Date to$value = this.to$value;
            if (!this.to$set) {
                to$value = AggregationRequest.$default$to();
            }
            int limit$value = this.limit$value;
            if (!this.limit$set) {
                limit$value = AggregationRequest.$default$limit();
            }
            QueryParamEntity filter$value = this.filter$value;
            if (!this.filter$set) {
                filter$value = AggregationRequest.$default$filter();
            }
            return new AggregationRequest(interval$value, format$value, from$value, to$value, limit$value, filter$value);
        }

        public String toString() {
            return "AggregationRequest.AggregationRequestBuilder(interval$value=" + this.interval$value + ", format$value=" + this.format$value + ", from$value=" + this.from$value + ", to$value=" + this.to$value + ", limit$value=" + this.limit$value + ", filter$value=" + this.filter$value + ")";
        }
    }
}

