/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.things;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.tdengine.things.TDengineThingDataHelper;
import org.jetlinks.community.things.data.AggregationRequest;
import org.jetlinks.community.things.data.PropertyAggregation;
import org.jetlinks.community.things.data.ThingPropertyDetail;
import org.jetlinks.community.things.data.operations.AbstractQueryOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.things.data.operations.RowModeQueryOperationsBase;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.reactor.ql.utils.CastUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class TDengineRowModeQueryOperations
extends RowModeQueryOperationsBase {
    final TDengineThingDataHelper helper;

    public TDengineRowModeQueryOperations(String thingType, String thingTemplateId, String thingId, MetricBuilder metricBuilder, DataSettings settings, ThingsRegistry registry, TDengineThingDataHelper helper) {
        super(thingType, thingTemplateId, thingId, metricBuilder, settings, registry);
        this.helper = helper;
    }

    protected Flux<TimeSeriesData> doQuery(String metric, Query<?, QueryParamEntity> query) {
        return this.helper.doQuery(metric, query);
    }

    protected <T> Mono<PagerResult<T>> doQueryPage(String metric, Query<?, QueryParamEntity> query, Function<TimeSeriesData, T> mapper) {
        return this.helper.doQueryPage(metric, query, mapper);
    }

    protected Flux<ThingPropertyDetail> queryEachProperty(@Nonnull String metric, @Nonnull Query<?, QueryParamEntity> query, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        return super.queryEachProperty(metric, query, metadata, properties);
    }

    protected Flux<AggregationData> doAggregation(String metric, AggregationRequest request, AbstractQueryOperations.AggregationContext context) {
        PropertyAggregation[] properties = context.getProperties();
        StringJoiner agg = new StringJoiner("");
        agg.add("property,last(`_ts`) _ts");
        for (PropertyAggregation property : properties) {
            agg.add(",");
            agg.add(TDengineThingDataHelper.convertAggFunction(property));
            if (property.getAgg() == Aggregation.COUNT) {
                agg.add("(`value`)");
            } else {
                agg.add("(`numberValue`)");
            }
            agg.add(" `").add("value_" + property.getAlias()).add("`");
        }
        String sql = String.join((CharSequence)"", "`", metric, "` ", this.helper.buildWhere(metric, (QueryParamEntity)request.getFilter().clone().and("property", "in", context.getPropertyAlias().values()).and("_ts", "btw", Arrays.asList(request.getFrom(), request.getTo())), new String[0]));
        String dataSql = "select " + agg + " from " + sql + " partition by property";
        if (request.getInterval() != null) {
            dataSql = dataSql + " ";
            dataSql = dataSql + TDengineThingDataHelper.getGroupByTime(request.getInterval());
        }
        String format = request.getFormat();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        if (properties.length == 1) {
            String key = "value_" + properties[0].getAlias();
            return this.helper.query(dataSql).sort(Comparator.comparing(TimeSeriesData::getTimestamp).reversed()).map(timeSeriesData -> {
                long ts = timeSeriesData.getTimestamp();
                HashMap<String, Object> newData = new HashMap<String, Object>();
                newData.put("time", formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneId.systemDefault())));
                newData.put(properties[0].getAlias(), timeSeriesData.get(key).orElse(0));
                return AggregationData.of(newData);
            }).take((long)request.getLimit());
        }
        return this.helper.query(dataSql).map(timeSeriesData -> {
            long ts = timeSeriesData.getTimestamp();
            Map newData = timeSeriesData.getData();
            newData.put("time", formatter.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneId.systemDefault())));
            newData.put("_time", ts);
            return newData;
        }).groupBy(data -> (String)data.get("time"), Integer.MAX_VALUE).flatMap(group -> group.reduceWith(HashMap::new, (a, b) -> {
            a.putAll(b);
            return a;
        }).map(map -> {
            HashMap<String, Object> newResult = new HashMap<String, Object>();
            for (PropertyAggregation property : properties) {
                String key = "value_" + property.getAlias();
                newResult.put(property.getAlias(), Optional.ofNullable(map.get(key)).orElse(0));
            }
            newResult.put("time", group.key());
            newResult.put("_time", map.getOrDefault("_time", new Date()));
            return AggregationData.of(newResult);
        })).sort(Comparator.comparing(data -> CastUtils.castDate(data.values().get("_time"))).reversed()).doOnNext(data -> data.values().remove("_time")).take((long)request.getLimit());
    }
}

