/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.metadata;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.ezorm.core.meta.ObjectMetadata;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.parser.TableMetadataParser;
import org.jetlinks.reactor.ql.utils.CastUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TDengineMetadataParser
implements TableMetadataParser {
    private final RDBSchemaMetadata schema;

    private ReactiveSqlExecutor sql() {
        return (ReactiveSqlExecutor)this.schema.findFeatureNow(ReactiveSqlExecutor.ID);
    }

    public List<String> parseAllTableName() {
        throw new UnsupportedOperationException();
    }

    public Flux<String> parseAllTableNameReactive() {
        return this.sql().select("show stables", ResultWrappers.map()).mapNotNull(map -> (String)map.get("stable_name"));
    }

    public boolean tableExists(String name) {
        throw new UnsupportedOperationException();
    }

    public Mono<Boolean> tableExistsReactive(String name) {
        return this.parseAllTableNameReactive().hasElement((Object)name);
    }

    public Optional<? extends ObjectMetadata> parseByName(String s) {
        throw new UnsupportedOperationException();
    }

    public List<? extends ObjectMetadata> parseAll() {
        throw new UnsupportedOperationException();
    }

    public Mono<RDBTableMetadata> parseByNameReactive(String name) {
        RDBTableMetadata table = this.schema.newTable(name);
        return this.sql().select("describe " + table.getFullName(), ResultWrappers.map()).doOnNext(column -> table.addColumn(this.convertToColumn((Map<String, Object>)column))).then(Mono.fromSupplier(() -> table.getColumns().isEmpty() ? null : table));
    }

    private RDBColumnMetadata convertToColumn(Map<String, Object> columnInfo) {
        String note = (String)columnInfo.getOrDefault("Note", "");
        String column = (String)columnInfo.get("Field");
        String type = (String)columnInfo.get("Type");
        int length = CastUtils.castNumber((Object)columnInfo.get("Length")).intValue();
        RDBColumnMetadata metadata = new RDBColumnMetadata();
        metadata.setName(column);
        metadata.setProperty("tag", (Object)"tag".equalsIgnoreCase(note));
        metadata.setLength(length);
        metadata.setType(this.schema.getDialect().convertDataType(type));
        return metadata;
    }

    public Flux<RDBTableMetadata> parseAllReactive() {
        return this.parseAllTableNameReactive().flatMap(this::parseByNameReactive);
    }

    public TDengineMetadataParser(RDBSchemaMetadata schema) {
        this.schema = schema;
    }
}

