/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.parser;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.tcp.parser.LengthFieldPayloadParserBuilder;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.community.network.tcp.parser.PayloadParserBuilder;
import org.jetlinks.community.network.tcp.parser.PayloadParserBuilderStrategy;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;
import org.jetlinks.community.network.tcp.parser.strateies.DelimitedPayloadParserBuilder;
import org.jetlinks.community.network.tcp.parser.strateies.DirectPayloadParserBuilder;
import org.jetlinks.community.network.tcp.parser.strateies.FixLengthPayloadParserBuilder;
import org.jetlinks.community.network.tcp.parser.strateies.ScriptPayloadParserBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class DefaultPayloadParserBuilder
implements PayloadParserBuilder,
BeanPostProcessor {
    private final Map<PayloadParserType, PayloadParserBuilderStrategy> strategyMap = new ConcurrentHashMap<PayloadParserType, PayloadParserBuilderStrategy>();

    public DefaultPayloadParserBuilder() {
        this.register(new FixLengthPayloadParserBuilder());
        this.register(new DelimitedPayloadParserBuilder());
        this.register(new ScriptPayloadParserBuilder());
        this.register(new DirectPayloadParserBuilder());
        this.register(new LengthFieldPayloadParserBuilder());
    }

    @Override
    public Supplier<PayloadParser> build(PayloadParserType type, ValueObject configuration) {
        return Optional.ofNullable(this.strategyMap.get((Object)type)).map(builder -> builder.buildLazy(configuration)).orElseThrow(() -> new UnsupportedOperationException("unsupported parser:" + (Object)((Object)type)));
    }

    public void register(PayloadParserBuilderStrategy strategy) {
        this.strategyMap.put(strategy.getType(), strategy);
    }

    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) throws BeansException {
        if (bean instanceof PayloadParserBuilderStrategy) {
            this.register((PayloadParserBuilderStrategy)bean);
        }
        return bean;
    }
}

