/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.server;

import io.vertx.core.Vertx;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.Network;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.security.CertificateManager;
import org.jetlinks.community.network.security.VertxKeyCertTrustOptions;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.community.network.tcp.parser.PayloadParserBuilder;
import org.jetlinks.community.network.tcp.server.TcpServerProperties;
import org.jetlinks.community.network.tcp.server.VertxTcpServer;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DefaultTcpServerProvider
implements NetworkProvider<TcpServerProperties> {
    private static final Logger log = LoggerFactory.getLogger(DefaultTcpServerProvider.class);
    private final CertificateManager certificateManager;
    private final Vertx vertx;
    private final PayloadParserBuilder payloadParserBuilder;

    public DefaultTcpServerProvider(CertificateManager certificateManager, Vertx vertx, PayloadParserBuilder payloadParserBuilder) {
        this.certificateManager = certificateManager;
        this.vertx = vertx;
        this.payloadParserBuilder = payloadParserBuilder;
    }

    @Nonnull
    public NetworkType getType() {
        return DefaultNetworkType.TCP_SERVER;
    }

    @Nonnull
    public Mono<Network> createNetwork(@Nonnull TcpServerProperties properties) {
        VertxTcpServer tcpServer = new VertxTcpServer(properties.getId());
        return this.initTcpServer(tcpServer, properties);
    }

    private Mono<Network> initTcpServer(VertxTcpServer tcpServer, TcpServerProperties properties) {
        return this.convert(properties).map(options -> {
            int instance = Math.max(2, properties.getInstance());
            ArrayList<NetServer> instances = new ArrayList<NetServer>(instance);
            for (int i = 0; i < instance; ++i) {
                instances.add(this.vertx.createNetServer(options));
            }
            Supplier<PayloadParser> parserSupplier = this.payloadParserBuilder.build(properties.getParserType(), properties);
            parserSupplier.get();
            tcpServer.setParserSupplier(parserSupplier);
            tcpServer.setServer(instances);
            tcpServer.setKeepAliveTimeout(properties.getLong("keepAliveTimeout", Duration.ofMinutes(10L).toMillis()));
            tcpServer.setBind(new InetSocketAddress(properties.getHost(), properties.getPort()));
            for (NetServer netServer : instances) {
                this.vertx.nettyEventLoopGroup().execute(() -> netServer.listen(properties.createSocketAddress(), result -> {
                    if (result.succeeded()) {
                        log.info("tcp server startup on {}", (Object)((NetServer)result.result()).actualPort());
                    } else {
                        tcpServer.setLastError(result.cause().getMessage());
                        log.error("startup tcp server error", result.cause());
                    }
                }));
            }
            return tcpServer;
        });
    }

    public Mono<Network> reload(@Nonnull Network network, @Nonnull TcpServerProperties properties) {
        VertxTcpServer tcpServer = (VertxTcpServer)network;
        tcpServer.shutdown();
        return this.initTcpServer(tcpServer, properties);
    }

    @Nullable
    public ConfigMetadata getConfigMetadata() {
        return new DefaultConfigMetadata().add("host", "\u672c\u5730\u5730\u5740", "", (DataType)new StringType()).add("port", "\u672c\u5730\u7aef\u53e3", "", (DataType)new IntType()).add("publicHost", "\u516c\u7f51\u5730\u5740", "", (DataType)new StringType()).add("publicPort", "\u516c\u7f51\u7aef\u53e3", "", (DataType)new IntType()).add("certId", "CA\u8bc1\u4e66", "", (DataType)new StringType().expand("selector", (Object)"cert")).add("secure", "\u5f00\u542fTSL", "", (DataType)new BooleanType()).add("parserType", "\u89e3\u6790\u5668\u7c7b\u578b", "", (DataType)new ObjectType()).add("parserConfiguration", "\u914d\u7f6e\u89e3\u6790\u5668", "", (DataType)new ObjectType());
    }

    @Nonnull
    public Mono<TcpServerProperties> createConfig(@Nonnull NetworkProperties properties) {
        return (Mono)Mono.fromSupplier(() -> {
            TcpServerProperties config = (TcpServerProperties)((Object)((Object)FastBeanCopier.copy((Object)properties.getConfigurations(), (Object)((Object)new TcpServerProperties()), (String[])new String[0])));
            config.setId(properties.getId());
            config.validate();
            return config;
        }).as(LocaleUtils::transform);
    }

    private Mono<NetServerOptions> convert(TcpServerProperties properties) {
        NetServerOptions options = new NetServerOptions();
        options.setPort(properties.getPort());
        options.setTcpKeepAlive(true);
        if (properties.isSecure()) {
            options.setSsl(true);
            return this.certificateManager.getCertificate(properties.getCertId()).map(VertxKeyCertTrustOptions::new).doOnNext(arg_0 -> ((NetServerOptions)options).setKeyCertOptions(arg_0)).doOnNext(arg_0 -> ((NetServerOptions)options).setTrustOptions(arg_0)).thenReturn((Object)options);
        }
        return Mono.just((Object)options);
    }
}

