/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.script.jsr223;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import org.jetlinks.community.script.AbstractScriptFactory;
import org.jetlinks.community.script.CompiledScript;
import org.jetlinks.community.script.Script;
import org.jetlinks.community.script.context.ExecutionContext;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr223ScriptFactory
extends AbstractScriptFactory {
    private static final Logger log = LoggerFactory.getLogger(Jsr223ScriptFactory.class);
    private final ScriptEngine engine = this.createEngine();

    protected abstract ScriptEngine createEngine();

    @Override
    public final CompiledScript compile(Script script) {
        return this.compile(script, true);
    }

    private CompiledScript compile(Script script, boolean convert) {
        ExecutionContext ctx = ExecutionContext.create(new Map[0]);
        ctx.setAttribute("console", new Console(LoggerFactory.getLogger((String)("org.jetlinks.community.script." + script.getName()))), 100);
        ctx.setAttribute("utils", this.getUtils(), 100);
        ctx.setAttribute("engine", null, 100);
        javax.script.CompiledScript compiledScript = this.compile0(script);
        return context -> this.eval(compiledScript, script, ExecutionContext.compose(ctx, context), convert);
    }

    private Object eval(javax.script.CompiledScript script, Script source, ExecutionContext context, boolean convert) {
        Object res = script.eval(this.acceptScriptContext(source, context));
        return convert ? this.convertToJavaType(res) : res;
    }

    protected ExecutionContext acceptScriptContext(Script script, ExecutionContext context) {
        return context;
    }

    @Override
    public final <T> T bind(Script script, Class<T> interfaceType) {
        String returns = this.createFunctionMapping(interfaceType.getDeclaredMethods());
        String content = script.getContent() + "\n return " + returns + ";";
        CompiledScript compiledScript = this.compile(script.content(content), false);
        Object source = compiledScript.call(Collections.emptyMap());
        HashSet ignoreMethods = new HashSet();
        return (T)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, (proxy, method, args) -> {
            if (ignoreMethods.contains(method)) {
                return this.convertValue(method, null);
            }
            try {
                return this.convertValue(method, ((Invocable)((Object)this.engine)).invokeMethod(source, method.getName(), args));
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    log.info("method [{}] undefined in script", (Object)method, (Object)e);
                    ignoreMethods.add(method);
                }
                return this.convertValue(method, null);
            }
        });
    }

    protected boolean valueIsUndefined(Object value) {
        return value == null;
    }

    @Override
    public Object convertToJavaType(Object value) {
        return value;
    }

    private Object convertValue(Method method, Object value) {
        if (this.valueIsUndefined(value)) {
            return null;
        }
        value = this.convertToJavaType(value);
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return null;
        }
        if (returnType == Integer.TYPE) {
            return CastUtils.castNumber((Object)value).intValue();
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(CastUtils.castNumber((Object)value).floatValue());
        }
        if (returnType == Double.TYPE) {
            return CastUtils.castNumber((Object)value).doubleValue();
        }
        if (returnType == Long.TYPE) {
            return CastUtils.castNumber((Object)value).longValue();
        }
        if (returnType == Byte.TYPE) {
            return CastUtils.castNumber((Object)value).byteValue();
        }
        if (returnType == Short.TYPE) {
            return CastUtils.castNumber((Object)value).shortValue();
        }
        return value;
    }

    protected abstract String createFunctionMapping(Method[] var1);

    private javax.script.CompiledScript compile0(Script script) {
        String rewriteScript = this.prepare(script);
        log.debug("compile script :\n{}", (Object)rewriteScript);
        return ((Compilable)((Object)this.engine)).compile(rewriteScript);
    }

    protected String prepare(Script script) {
        return script.getContent();
    }

    public static class Console {
        private final Logger logger;

        public void trace(String text, Object ... args) {
            this.logger.trace(text, args);
        }

        public void warn(String text, Object ... args) {
            this.logger.warn(text, args);
        }

        public void log(String text, Object ... args) {
            this.logger.debug(text, args);
        }

        public void error(String text, Object ... args) {
            this.logger.error(text, args);
        }

        public Console(Logger logger) {
            this.logger = logger;
        }
    }
}

