/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.TimerSpec;
import org.jetlinks.community.rule.engine.scene.term.TermColumn;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.things.ThingMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DeviceOperation {
    public static final String property_value_type_current = "current";
    @NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null")
    private @NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null") Operator operator;
    @Schema(description="[operator]\u4e3a[readProperty,writeProperty,invokeFunction]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private TimerSpec timer;
    @Schema(description="[operator]\u4e3a[reportEvent]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private String eventId;
    @Schema(description="[operator]\u4e3a[readProperty]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private List<String> readProperties;
    @Schema(description="[operator]\u4e3a[writeProperty]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private Map<String, Object> writeProperties;
    @Schema(description="[operator]\u4e3a[invokeFunction]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private String functionId;
    @Schema(description="[operator]\u4e3a[invokeFunction]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private List<FunctionParameter> functionParameters;

    public static DeviceOperation reportProperty() {
        DeviceOperation operation = new DeviceOperation();
        operation.setOperator(Operator.reportProperty);
        return operation;
    }

    public static DeviceOperation invokeFunction(TimerSpec timer, String functionId, List<FunctionParameter> parameters) {
        DeviceOperation operation = new DeviceOperation();
        operation.setOperator(Operator.invokeFunction);
        operation.setFunctionId(functionId);
        operation.setTimer(timer);
        operation.setFunctionParameters(parameters);
        return operation;
    }

    public Map<String, Object> toMessageTemplate() {
        switch (this.operator) {
            case readProperty: {
                return new ReadPropertyMessage().addProperties(this.readProperties).toJson();
            }
            case writeProperty: {
                WritePropertyMessage message = new WritePropertyMessage();
                message.setProperties(this.writeProperties);
                return message.toJson();
            }
            case invokeFunction: {
                FunctionInvokeMessage message = new FunctionInvokeMessage();
                message.functionId(this.functionId);
                message.setInputs(this.functionParameters);
                return message.toJson();
            }
        }
        throw new UnsupportedOperationException("unsupported operator : " + (Object)((Object)this.operator));
    }

    public List<TermColumn> parseTermColumns(ThingMetadata metadata) {
        ArrayList<TermColumn> terms = new ArrayList<TermColumn>(32);
        terms.add(TermColumn.of("_now", this.resolveI18n("message.scene_term_column_now", "\u670d\u52a1\u5668\u65f6\u95f4"), (DataType)DateTimeType.GLOBAL, this.resolveI18n("message.scene_term_column_now_desc", "\u6536\u5230\u8bbe\u5907\u6570\u636e\u65f6,\u670d\u52a1\u5668\u7684\u65f6\u95f4.")));
        terms.add(TermColumn.of("timestamp", this.resolveI18n("message.scene_term_column_timestamp", "\u6570\u636e\u4e0a\u62a5\u65f6\u95f4"), (DataType)DateTimeType.GLOBAL, this.resolveI18n("message.scene_term_column_timestamp_desc", "\u8bbe\u5907\u4e0a\u62a5\u7684\u6570\u636e\u4e2d\u6307\u5b9a\u7684\u65f6\u95f4.")));
        if (this.operator == Operator.readProperty || this.operator == Operator.writeProperty || this.operator == Operator.invokeFunction) {
            terms.add(TermColumn.of("success", this.resolveI18n("message.scene_term_column_event_success", "\u573a\u666f\u89e6\u53d1\u662f\u5426\u6210\u529f"), (DataType)BooleanType.GLOBAL));
        }
        if (this.operator == Operator.readProperty || this.operator == Operator.reportProperty || this.operator == Operator.writeProperty) {
            terms.addAll(this.createTerm(metadata.getProperties(), (property, column) -> column.setChildren(this.createTermColumn("properties", (PropertyMetadata)property, true, PropertyValueType.values())), LocaleUtils.resolveMessage((String)"message.device_metadata_property", (String)"\u5c5e\u6027", (Object[])new Object[0])));
        } else {
            terms.addAll(this.createTerm(metadata.getProperties(), (property, column) -> column.setChildren(this.createTermColumn("properties", (PropertyMetadata)property, true, PropertyValueType.last)), LocaleUtils.resolveMessage((String)"message.device_metadata_property", (String)"\u5c5e\u6027", (Object[])new Object[0])));
        }
        if (this.operator == Operator.reportEvent) {
            terms.addAll(this.createTerm(metadata.getEvent(this.eventId).map(event -> Collections.singletonList(SimplePropertyMetadata.of((String)"data", (String)event.getName(), (DataType)event.getType()))).orElse(Collections.emptyList()), (property, column) -> column.setChildren(this.createTermColumn("event", (PropertyMetadata)property, false, new PropertyValueType[0])), new String[0]));
        }
        if (this.operator == Operator.invokeFunction) {
            terms.addAll(this.createTerm(metadata.getFunction(this.functionId).map(meta -> Collections.singletonList(SimplePropertyMetadata.of((String)"output", (String)meta.getName(), (DataType)meta.getOutput()))).orElse(Collections.emptyList()), (property, column) -> column.setChildren(this.createTermColumn("function", (PropertyMetadata)property, false, new PropertyValueType[0])), new String[0]));
        }
        Map allColumn = terms.stream().collect(Collectors.toMap(TermColumn::getColumn, Function.identity(), (a, b) -> a));
        for (TermColumn term : terms) {
            term.refactorDescription(allColumn::get);
            term.refactorFullName(null);
        }
        return terms;
    }

    private String resolveI18n(String key, String name) {
        return LocaleUtils.resolveMessage((String)key, (String)name, (Object[])new Object[0]);
    }

    private String appendColumn(String ... columns) {
        StringJoiner joiner = new StringJoiner(".");
        for (String column : columns) {
            if (!StringUtils.hasText((String)column)) continue;
            joiner.add(column);
        }
        return joiner.toString();
    }

    private List<TermColumn> createTermColumn(String prefix, PropertyMetadata property, boolean last, PropertyValueType ... valueTypes) {
        if (property.getValueType() instanceof ObjectType) {
            ObjectType objType = (ObjectType)property.getValueType();
            return this.createTerm(objType.getProperties(), (prop, column) -> {
                String _prefix;
                String string = _prefix = prefix == null ? property.getId() : prefix + "." + property.getId();
                if (!last && !(prop.getValueType() instanceof ObjectType)) {
                    TermColumn term = this.createTermColumn(_prefix, (PropertyMetadata)prop, false, valueTypes).get(0);
                    column.setColumn(term.getColumn());
                    column.setName(term.getName());
                } else {
                    column.setChildren(this.createTermColumn(_prefix, (PropertyMetadata)prop, last, valueTypes));
                }
            }, new String[0]);
        }
        if (!last) {
            return Collections.singletonList(TermColumn.of(this.appendColumn(prefix, property.getId()), property.getName(), property.getValueType()).withMetrics(property).withMetadataTrue());
        }
        return Arrays.stream(valueTypes).map(type -> TermColumn.of(this.appendColumn(prefix, property.getId(), type.name()), type.getName(), property.getValueType()).withMetrics(property).withMetadataTrue()).collect(Collectors.toList());
    }

    private List<TermColumn> createTerm(List<PropertyMetadata> metadataList, BiConsumer<PropertyMetadata, TermColumn> consumer, String ... description) {
        ArrayList<TermColumn> columns = new ArrayList<TermColumn>(metadataList.size());
        for (PropertyMetadata metadata : metadataList) {
            TermColumn column = TermColumn.of(metadata);
            column.setDescription(String.join((CharSequence)"", description));
            consumer.accept(metadata, column);
            columns.add(column.withMetadataTrue());
        }
        return columns;
    }

    public void validate() {
        Assert.notNull((Object)((Object)this.operator), (String)"error.scene_rule_trigger_device_operation_cannot_be_null");
        switch (this.operator) {
            case online: 
            case offline: 
            case reportProperty: {
                return;
            }
            case reportEvent: {
                Assert.hasText((String)this.eventId, (String)"error.scene_rule_trigger_device_operation_event_id_cannot_be_null");
                return;
            }
            case readProperty: {
                Assert.notEmpty(this.readProperties, (String)"error.scene_rule_trigger_device_operation_read_property_cannot_be_empty");
                return;
            }
            case writeProperty: {
                Assert.notEmpty(this.writeProperties, (String)"error.scene_rule_trigger_device_operation_write_property_cannot_be_empty");
                return;
            }
            case invokeFunction: {
                Assert.hasText((String)this.functionId, (String)"error.scene_rule_trigger_device_operation_function_id_cannot_be_null");
                Assert.notEmpty(this.functionParameters, (String)"error.scene_rule_trigger_device_operation_function_parameter_cannot_be_empty");
            }
        }
    }

    @NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null")
    public @NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null") Operator getOperator() {
        return this.operator;
    }

    public TimerSpec getTimer() {
        return this.timer;
    }

    public String getEventId() {
        return this.eventId;
    }

    public List<String> getReadProperties() {
        return this.readProperties;
    }

    public Map<String, Object> getWriteProperties() {
        return this.writeProperties;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public List<FunctionParameter> getFunctionParameters() {
        return this.functionParameters;
    }

    public void setOperator(@NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null") @NotNull(message="error.scene_rule_trigger_device_operation_cannot_be_null") Operator operator) {
        this.operator = operator;
    }

    public void setTimer(TimerSpec timer) {
        this.timer = timer;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setReadProperties(List<String> readProperties) {
        this.readProperties = readProperties;
    }

    public void setWriteProperties(Map<String, Object> writeProperties) {
        this.writeProperties = writeProperties;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setFunctionParameters(List<FunctionParameter> functionParameters) {
        this.functionParameters = functionParameters;
    }

    public static enum PropertyValueType {
        current("message.property_value_type_current"),
        recent("message.property_value_type_recent"),
        last("message.property_value_type_last");

        private final String key;

        public String getName() {
            return LocaleUtils.resolveMessage((String)this.key, (Object[])new Object[0]);
        }

        public String getDescription() {
            return LocaleUtils.resolveMessage((String)(this.key + "_desc"), (Object[])new Object[0]);
        }

        public String getNestDescription(String parentName) {
            String key = this.key + "_nest_desc";
            return LocaleUtils.resolveMessage((String)key, (String)key, (Object[])new Object[]{parentName});
        }

        private PropertyValueType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum Operator {
        online,
        offline,
        reportEvent,
        reportProperty,
        readProperty,
        writeProperty,
        invokeFunction;

    }
}

