/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.rule.engine.scene.SceneData;
import org.jetlinks.community.rule.engine.scene.SceneFilter;
import org.jetlinks.core.utils.Reactors;
import reactor.bool.BooleanUtils;
import reactor.core.publisher.Mono;

class CompositeSceneFilter
implements SceneFilter {
    private final List<SceneFilter> filters;

    @Override
    public Mono<Boolean> filter(SceneData data) {
        if (CollectionUtils.isEmpty(this.filters)) {
            return Reactors.ALWAYS_TRUE;
        }
        Mono handler = null;
        for (SceneFilter filter : this.filters) {
            if (handler == null) {
                handler = filter.filter(data);
                continue;
            }
            handler = BooleanUtils.and(handler, (Mono)handler.filter(Boolean::booleanValue));
        }
        return handler;
    }

    public CompositeSceneFilter(List<SceneFilter> filters) {
        this.filters = filters;
    }
}

