/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.service;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.jetlinks.community.rule.engine.alarm.AlarmLevelInfo;
import org.jetlinks.community.rule.engine.entity.AlarmLevelEntity;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import reactor.core.publisher.Mono;

@Service
public class AlarmLevelService
extends GenericReactiveCrudService<AlarmLevelEntity, String>
implements CommandLineRunner {
    public static final String DEFAULT_ALARM_ID = "default-alarm-id";

    private Mono<Void> initDefaultData() {
        return this.findById(DEFAULT_ALARM_ID).switchIfEmpty(Mono.fromCallable(() -> {
            ClassPathResource resource = new ClassPathResource("alarm-level.json");
            try (InputStream stream = resource.getInputStream();){
                String json = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                List levelInfo = JSON.parseArray((String)json, AlarmLevelInfo.class);
                AlarmLevelEntity alarmLevelEntity = AlarmLevelEntity.defaultOf(levelInfo);
                return alarmLevelEntity;
            }
        }).flatMap(e -> this.save(e).thenReturn((Object)e))).then();
    }

    public void run(String ... args) throws Exception {
        this.initDefaultData().subscribe();
    }
}

