/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.rule.engine.alarm.AlarmHandleInfo;
import org.jetlinks.community.rule.engine.entity.AlarmConfigDetail;
import org.jetlinks.community.rule.engine.entity.AlarmConfigEntity;
import org.jetlinks.community.rule.engine.entity.AlarmHandleHistoryEntity;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.enums.AlarmState;
import org.jetlinks.community.rule.engine.service.AlarmRecordService;
import org.jetlinks.community.rule.engine.service.SceneService;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Service
public class AlarmConfigService
extends GenericReactiveCrudService<AlarmConfigEntity, String> {
    private final AlarmRecordService alarmRecordService;
    private final ReactiveRepository<AlarmHandleHistoryEntity, String> handleHistoryRepository;
    private final SceneService sceneService;

    public Mono<Void> handleAlarm(AlarmHandleInfo info) {
        return this.alarmRecordService.changeRecordState(info.getState(), info.getAlarmRecordId()).flatMap(total -> {
            if (total > 0) {
                return this.handleHistoryRepository.save((Object)AlarmHandleHistoryEntity.of(info));
            }
            return Mono.error((Throwable)new BusinessException("error.the_alarm_record_has_been_processed"));
        }).then();
    }

    public Mono<PagerResult<AlarmConfigDetail>> queryDetailPager(QueryParamEntity query) {
        return this.queryPager(query).flatMap(result -> Flux.fromIterable((Iterable)result.getData()).index().flatMap(tp2 -> this.convertDetail((AlarmConfigEntity)((Object)((Object)((Object)tp2.getT2())))).map(detail -> Tuples.of((Object)tp2.getT1(), (Object)detail))).sort(Comparator.comparingLong(Tuple2::getT1)).map(Tuple2::getT2).collectList().map(detail -> PagerResult.of((int)result.getTotal(), (List)detail, (QueryParam)query)));
    }

    private Mono<AlarmConfigDetail> convertDetail(AlarmConfigEntity entity) {
        return ((ReactiveQuery)this.sceneService.createQuery().and(GenericEntity::getId, "alarm-bind-rule", entity.getId())).fetch().collectList().map(sceneInfo -> AlarmConfigDetail.of(entity).withScene((List<SceneEntity>)sceneInfo));
    }

    @EventListener
    @Deprecated
    public void handleSceneSaved(EntitySavedEvent<SceneEntity> event) {
        event.async((Publisher)Mono.defer(() -> Flux.fromIterable((Iterable)event.getEntity()).flatMap(this::updateByScene).then()));
    }

    @EventListener
    @Deprecated
    public void handleSceneSaved(EntityModifyEvent<SceneEntity> event) {
        Map before = event.getBefore().stream().collect(Collectors.toMap(GenericEntity::getId, Function.identity()));
        event.async((Publisher)Flux.fromIterable((Iterable)event.getAfter()).filter(scene -> StringUtils.hasText((String)scene.getName()) && before.get(scene.getId()) != null && (!Objects.equals(((SceneEntity)((Object)((Object)before.get(scene.getId())))).getName(), scene.getName()) || !Objects.equals((Object)((SceneEntity)((Object)((Object)before.get(scene.getId())))).getTriggerType(), (Object)scene.getTriggerType()))).flatMap(this::updateByScene));
    }

    @Deprecated
    public Mono<Void> updateByScene(SceneEntity entity) {
        return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(AlarmConfigEntity::getSceneName, (Object)entity.getName())).set(AlarmConfigEntity::getSceneTriggerType, (Object)entity.getTriggerType())).where(AlarmConfigEntity::getSceneId, entity.getId())).execute().then();
    }

    public Mono<Void> enable(String id) {
        return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(AlarmConfigEntity::getState, (Object)AlarmState.enabled)).where(GenericEntity::getId, (Object)id)).execute().then();
    }

    public Mono<Void> disable(String id) {
        return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(AlarmConfigEntity::getState, (Object)AlarmState.disabled)).where(GenericEntity::getId, (Object)id)).execute().then();
    }

    public AlarmConfigService(AlarmRecordService alarmRecordService, ReactiveRepository<AlarmHandleHistoryEntity, String> handleHistoryRepository, SceneService sceneService) {
        this.alarmRecordService = alarmRecordService;
        this.handleHistoryRepository = handleHistoryRepository;
        this.sceneService = sceneService;
    }
}

