/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene.value;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.bean.FastBeanCopier;

public class TermValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6765\u6e90")
    private Source source;
    @Schema(description="[source]\u4e3a[manual]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private Object value;
    @Schema(description="[source]\u4e3a[metric]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private String metric;

    public static TermValue manual(Object value) {
        TermValue termValue = new TermValue();
        termValue.setValue(value);
        termValue.setSource(Source.manual);
        return termValue;
    }

    public static TermValue metric(String metric) {
        TermValue termValue = new TermValue();
        termValue.setMetric(metric);
        termValue.setSource(Source.metric);
        return termValue;
    }

    public static List<TermValue> of(Term term) {
        return TermValue.of(term.getValue());
    }

    public static List<TermValue> of(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Map) {
            return Collections.singletonList(FastBeanCopier.copy((Object)value, (Object)new TermValue(), (String[])new String[0]));
        }
        if (value instanceof TermValue) {
            return Collections.singletonList((TermValue)value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().flatMap(val -> TermValue.of(val).stream()).collect(Collectors.toList());
        }
        return Collections.singletonList(TermValue.manual(value));
    }

    public Source getSource() {
        return this.source;
    }

    public Object getValue() {
        return this.value;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public static enum Source {
        manual,
        metric,
        variable,
        upper;

    }
}

