/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.model;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import org.jetlinks.community.rule.engine.enums.SqlRuleType;
import org.jetlinks.community.rule.engine.model.Action;
import org.jetlinks.community.rule.engine.ql.SqlRule;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import org.jetlinks.rule.engine.model.RuleModelParserStrategy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class SqlRuleModelParser
implements RuleModelParserStrategy {
    public String getFormat() {
        return "sql_rule";
    }

    public RuleModel parse(String modelDefineString) {
        RuleLink link;
        RuleNodeModel action;
        int index;
        SqlRule sqlRule = (SqlRule)JSON.parseObject((String)modelDefineString, SqlRule.class);
        sqlRule.validate();
        RuleModel model = new RuleModel();
        model.setId(sqlRule.getId());
        model.setName(sqlRule.getName());
        RuleNodeModel sqlNode = new RuleNodeModel();
        sqlNode.setId("sql");
        sqlNode.setExecutor("reactor-ql");
        sqlNode.setConfiguration(Collections.singletonMap("sql", sqlRule.getSql()));
        sqlNode.setName("SQL");
        model.getNodes().add(sqlNode);
        ArrayList<RuleLink> errorHandler = new ArrayList<RuleLink>();
        if (!CollectionUtils.isEmpty(sqlRule.getWhenErrorThen())) {
            index = 0;
            for (Action act : sqlRule.getWhenErrorThen()) {
                if (!StringUtils.hasText((String)act.getExecutor())) continue;
                action = new RuleNodeModel();
                action.setId("error:action:" + ++index);
                action.setName("\u9519\u8bef\u5904\u7406:" + index);
                action.setExecutor(act.getExecutor());
                action.setConfiguration(act.getConfiguration());
                link = new RuleLink();
                link.setId(action.getId().concat(":").concat(action.getId()));
                link.setName("\u9519\u8bef\u5904\u7406:" + index);
                link.setSource(sqlNode);
                link.setType("error");
                link.setTarget(action);
                errorHandler.add(link);
                model.getNodes().add(action);
            }
        }
        sqlNode.getEvents().addAll(errorHandler);
        if (sqlRule.getType() == SqlRuleType.timer) {
            RuleNodeModel timerNode = new RuleNodeModel();
            timerNode.setId("timer");
            timerNode.setExecutor("timer");
            timerNode.setName("\u5b9a\u65f6\u89e6\u53d1");
            timerNode.setConfiguration(Collections.singletonMap("cron", sqlRule.getCron()));
            timerNode.setRuleId(model.getId());
            RuleLink link2 = new RuleLink();
            link2.setId("sql:timer");
            link2.setName("\u5b9a\u65f6\u89e6\u53d1SQL");
            link2.setSource(timerNode);
            link2.setTarget(sqlNode);
            timerNode.getOutputs().add(link2);
            sqlNode.getInputs().add(link2);
            model.getNodes().add(timerNode);
        }
        if (!CollectionUtils.isEmpty(sqlRule.getActions())) {
            index = 0;
            for (Action operation : sqlRule.getActions()) {
                if (!StringUtils.hasText((String)operation.getExecutor())) continue;
                action = new RuleNodeModel();
                action.setId("action:" + ++index);
                action.setName("\u6267\u884c\u52a8\u4f5c:" + index);
                action.setExecutor(operation.getExecutor());
                action.setConfiguration(operation.getConfiguration());
                link = new RuleLink();
                link.setId(action.getId().concat(":").concat(action.getId()));
                link.setName("\u6267\u884c\u52a8\u4f5c:" + index);
                link.setSource(sqlNode);
                link.setTarget(action);
                model.getNodes().add(action);
                action.getInputs().add(link);
                sqlNode.getOutputs().add(link);
                action.getEvents().addAll(errorHandler);
            }
        }
        return model;
    }
}

