/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.alarm;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.rule.engine.alarm.AlarmRuleHandler;
import org.jetlinks.community.rule.engine.enums.AlarmMode;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.FunctionTaskExecutor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class AlarmTaskExecutorProvider
implements TaskExecutorProvider {
    private static final Logger log = LoggerFactory.getLogger(AlarmTaskExecutorProvider.class);
    public static final String executor = "alarm";
    private final AlarmRuleHandler alarmHandler;

    public String getExecutor() {
        return executor;
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)((Object)new AlarmTaskExecutor(context, this.alarmHandler)));
    }

    public AlarmTaskExecutorProvider(AlarmRuleHandler alarmHandler) {
        this.alarmHandler = alarmHandler;
    }

    public static class Config
    implements Serializable {
        @NotNull
        @Schema(description="\u544a\u8b66\u65b9\u5f0f")
        private AlarmMode mode;

        @NotNull
        public AlarmMode getMode() {
            return this.mode;
        }

        public void setMode(@NotNull AlarmMode mode) {
            this.mode = mode;
        }
    }

    static class AlarmTaskExecutor
    extends FunctionTaskExecutor {
        private final AlarmRuleHandler handler;
        private Function<RuleData, Flux<AlarmRuleHandler.Result>> executor;
        private Config config;

        public AlarmTaskExecutor(ExecutionContext context, AlarmRuleHandler handler) {
            super("\u544a\u8b66", context);
            this.handler = handler;
            this.reload();
        }

        public String getName() {
            return this.config.getMode() == AlarmMode.relieve ? "\u89e3\u9664\u544a\u8b66" : "\u89e6\u53d1\u544a\u8b66";
        }

        protected Publisher<RuleData> apply(RuleData input) {
            return this.executor.apply(input).doOnError(err -> log.warn("{} alarm error,rule:{}", new Object[]{this.config.mode, this.context.getInstanceId(), err})).map(result -> this.context.newRuleData((Object)input.newData(result.toMap())));
        }

        public void reload() {
            this.config = (Config)FastBeanCopier.copy((Object)this.context.getJob().getConfiguration(), (Object)new Config(), (String[])new String[0]);
            ValidatorUtils.tryValidate((Object)this.config, (Class[])new Class[0]);
            this.executor = this.config.mode == AlarmMode.relieve ? input -> this.handler.relieved(this.context, (RuleData)input) : input -> this.handler.triggered(this.context, (RuleData)input);
        }
    }
}

