/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.web.authorization.annotation.DeleteAction;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceQueryController;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProvider;
import org.jetlinks.community.rule.engine.executor.device.DeviceSelectorProviders;
import org.jetlinks.community.rule.engine.scene.SceneRule;
import org.jetlinks.community.rule.engine.scene.Trigger;
import org.jetlinks.community.rule.engine.scene.TriggerType;
import org.jetlinks.community.rule.engine.scene.Variable;
import org.jetlinks.community.rule.engine.scene.term.TermColumn;
import org.jetlinks.community.rule.engine.service.SceneService;
import org.jetlinks.community.rule.engine.web.request.SceneExecuteRequest;
import org.jetlinks.core.device.DeviceRegistry;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/scene"})
@Tag(name="\u573a\u666f\u7ba1\u7406")
@Resource(id="rule-scene", name="\u573a\u666f\u7ba1\u7406")
public class SceneController
implements ReactiveServiceQueryController<SceneEntity, String> {
    private final DeviceRegistry deviceRegistry;
    private final SceneService service;

    @PostMapping
    @Operation(summary="\u521b\u5efa\u573a\u666f")
    @SaveAction
    public Mono<SceneEntity> createScene(@RequestBody Mono<SceneRule> sceneRuleMono) {
        return sceneRuleMono.flatMap(this.service::createScene);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="\u66f4\u65b0\u573a\u666f")
    @SaveAction
    public Mono<Void> update(@PathVariable String id, @RequestBody Mono<SceneRule> sceneRuleMono) {
        return sceneRuleMono.flatMap(sceneRule -> this.service.updateScene(id, (SceneRule)sceneRule)).then();
    }

    @PutMapping(value={"/{id}/_disable"})
    @Operation(summary="\u7981\u7528\u573a\u666f")
    @SaveAction
    public Mono<Void> disableScene(@PathVariable String id) {
        return this.service.disabled(id);
    }

    @PutMapping(value={"/{id}/_enable"})
    @Operation(summary="\u542f\u7528\u573a\u666f")
    @SaveAction
    public Mono<Void> enabledScene(@PathVariable String id) {
        return this.service.enable(id);
    }

    @PostMapping(value={"/{id}/_execute"})
    @Operation(summary="\u624b\u52a8\u6267\u884c\u573a\u666f")
    @SaveAction
    public Mono<Void> execute(@PathVariable String id, @RequestBody Mono<Map<String, Object>> context) {
        return context.flatMap(ctx -> this.service.execute(id, (Map<String, Object>)ctx));
    }

    @PostMapping(value={"/batch/_execute"})
    @Operation(summary="\u6279\u91cf\u624b\u52a8\u6267\u884c\u573a\u666f")
    @SaveAction
    public Mono<Void> executeBatch(@RequestBody Flux<SceneExecuteRequest> request) {
        return this.service.executeBatch(request);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u5220\u9664\u573a\u666f")
    @DeleteAction
    public Mono<Void> removeScene(@PathVariable String id) {
        return this.service.deleteById(id).then();
    }

    @PostMapping(value={"/parse-term-column"})
    @Operation(summary="\u6839\u636e\u89e6\u53d1\u5668\u89e3\u6790\u51fa\u652f\u6301\u7684\u6761\u4ef6\u5217")
    @QueryAction
    public Flux<TermColumn> parseTermColumns(@RequestBody Mono<SceneRule> ruleMono) {
        return ruleMono.flatMapMany(rule -> {
            Trigger trigger = rule.getTrigger();
            if (trigger != null && trigger.getType() == TriggerType.device && trigger.getDevice() != null) {
                return trigger.getDevice().parseTermColumns(this.deviceRegistry);
            }
            return Flux.empty();
        });
    }

    @PostMapping(value={"/parse-variables"})
    @Operation(summary="\u89e3\u6790\u89c4\u5219\u4e2d\u8f93\u51fa\u7684\u53d8\u91cf")
    @QueryAction
    public Flux<Variable> parseVariables(@RequestBody Mono<SceneRule> ruleMono, @RequestParam(required=false) Integer branch, @RequestParam(required=false) Integer branchGroup, @RequestParam(required=false) Integer action) {
        Mono cache = ruleMono.cache();
        return Mono.zip((Mono)this.parseTermColumns((Mono<SceneRule>)cache).collectList(), (Mono)cache, (columns, rule) -> rule.createVariables((List<TermColumn>)columns, branch, branchGroup, action, this.deviceRegistry)).flatMapMany(Function.identity());
    }

    @GetMapping(value={"/device-selectors"})
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u8bbe\u5907\u9009\u62e9\u5668")
    @QueryAction
    public Flux<SelectorInfo> getDeviceSelectors() {
        return Flux.fromIterable((Iterable)DeviceSelectorProviders.allProvider()).filter(provider -> !"product".equals(provider.getProvider())).map(SelectorInfo::of);
    }

    public SceneController(DeviceRegistry deviceRegistry, SceneService service) {
        this.deviceRegistry = deviceRegistry;
        this.service = service;
    }

    public SceneService getService() {
        return this.service;
    }

    public static class SelectorInfo {
        @Schema(description="ID")
        private String id;
        @Schema(description="\u540d\u79f0")
        private String name;
        @Schema(description="\u8bf4\u660e")
        private String description;

        public static SelectorInfo of(DeviceSelectorProvider provider) {
            SelectorInfo info = new SelectorInfo();
            info.setId(provider.getProvider());
            info.setName(LocaleUtils.resolveMessage((String)("message.device_selector_" + provider.getProvider()), (String)provider.getName(), (Object[])new Object[0]));
            info.setDescription(LocaleUtils.resolveMessage((String)("message.device_selector_" + provider.getProvider() + "_desc"), (String)provider.getName(), (Object[])new Object[0]));
            return info;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

