/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.scene;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.executor.EmptySqlRequest;
import org.hswebframework.ezorm.rdb.executor.SqlRequest;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.reactorql.term.TermTypes;
import org.jetlinks.community.rule.engine.commons.ShakeLimit;
import org.jetlinks.community.rule.engine.commons.TermsConditionEvaluator;
import org.jetlinks.community.rule.engine.scene.SceneAction;
import org.jetlinks.community.rule.engine.scene.SceneActions;
import org.jetlinks.community.rule.engine.scene.SceneConditionAction;
import org.jetlinks.community.rule.engine.scene.SceneUtils;
import org.jetlinks.community.rule.engine.scene.Trigger;
import org.jetlinks.community.rule.engine.scene.TriggerType;
import org.jetlinks.community.rule.engine.scene.Variable;
import org.jetlinks.community.rule.engine.scene.term.TermColumn;
import org.jetlinks.community.rule.engine.scene.term.limit.ShakeLimitGrouping;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.rule.engine.api.model.RuleLink;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.api.model.RuleNodeModel;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.function.Function3;
import reactor.util.concurrent.Queues;

public class SceneRule
implements Serializable {
    public static final String ACTION_KEY_BRANCH_INDEX = "_branchIndex";
    public static final String ACTION_KEY_GROUP_INDEX = "_groupIndex";
    public static final String ACTION_KEY_ACTION_INDEX = "_actionIndex";
    public static final String CONTEXT_KEY_SCENE_OUTPUT = "scene";
    public static final String SOURCE_TYPE_KEY = "sourceType";
    public static final String SOURCE_ID_KEY = "sourceId";
    public static final String SOURCE_NAME_KEY = "sourceName";
    @Schema(description="\u544a\u8b66ID")
    @NotBlank(message="error.scene_rule_id_cannot_be_blank")
    private @NotBlank(message="error.scene_rule_id_cannot_be_blank") String id;
    @Schema(description="\u544a\u8b66\u540d\u79f0")
    @NotBlank(message="error.scene_rule_name_cannot_be_blank")
    private @NotBlank(message="error.scene_rule_name_cannot_be_blank") String name;
    @Schema(description="\u89e6\u53d1\u5668")
    @NotNull(message="error.scene_rule_trigger_cannot_be_null")
    private @NotNull(message="error.scene_rule_trigger_cannot_be_null") Trigger trigger;
    @Schema(description="\u89e6\u53d1\u6761\u4ef6")
    private List<Term> terms;
    @Schema(description="\u662f\u5426\u5e76\u884c\u6267\u884c\u52a8\u4f5c")
    private boolean parallel;
    @Schema(description="\u6267\u884c\u52a8\u4f5c")
    private List<SceneAction> actions;
    @Schema(description="\u52a8\u4f5c\u5206\u652f")
    private List<SceneConditionAction> branches;
    @Schema(description="\u6269\u5c55\u914d\u7f6e")
    private Map<String, Object> options;
    @Schema(description="\u8bf4\u660e")
    private String description;

    public SqlRequest createSql(boolean hasWhere) {
        if (this.trigger != null && this.trigger.getType() == TriggerType.device) {
            ArrayList<Term> terms = new ArrayList<Term>();
            if (CollectionUtils.isNotEmpty(this.terms)) {
                terms.addAll(this.terms);
            }
            if (CollectionUtils.isNotEmpty(this.branches)) {
                for (SceneConditionAction branch : this.branches) {
                    terms.addAll(branch.createContextTerm());
                }
            }
            return this.trigger.getDevice().createSql(terms, hasWhere);
        }
        return EmptySqlRequest.INSTANCE;
    }

    public Function<Map<String, Object>, Mono<Boolean>> createFilter(List<Term> terms) {
        if (this.trigger != null && this.trigger.getType() == TriggerType.device) {
            return this.trigger.getDevice().createFilter(terms);
        }
        return ignore -> Reactors.ALWAYS_TRUE;
    }

    String createFilterDescription(List<Term> terms) {
        if (this.trigger != null && this.trigger.getType() == TriggerType.device) {
            return this.trigger.getDevice().createFilterDescription(terms);
        }
        return "true";
    }

    public ShakeLimitGrouping<Map<String, Object>> createGrouping() {
        return flux -> flux.groupBy(map -> map.getOrDefault("deviceId", "null"), Integer.MAX_VALUE);
    }

    private Flux<Variable> createSceneVariables(List<TermColumn> columns) {
        return LocaleUtils.currentReactive().flatMapIterable(locale -> (List)LocaleUtils.doWith(this.terms, (Locale)locale, (terms, l) -> {
            Variable variable = Variable.of(CONTEXT_KEY_SCENE_OUTPUT, LocaleUtils.resolveMessage((String)("message.scene_trigger_" + this.trigger.getType().name() + "_output"), (String)(this.trigger.getType().getText() + "\u8f93\u51fa\u7684\u6570\u636e"), (Object[])new Object[0]));
            List<Variable> defaultVariables = this.createDefaultVariable();
            List<Variable> termVar = SceneUtils.parseVariable(terms, columns);
            ArrayList<Variable> variables = new ArrayList<Variable>(defaultVariables.size() + termVar.size());
            if (this.trigger.getType() != TriggerType.device) {
                variables.add(Variable.of("_now", LocaleUtils.resolveMessage((String)"message.scene_term_column_now", (String)"\u670d\u52a1\u5668\u65f6\u95f4", (Object[])new Object[0])).withType("date").withTermType(TermTypes.lookup((DataType)DateTimeType.GLOBAL)).withColumn("_now"));
            }
            variables.addAll(defaultVariables);
            variables.addAll(termVar);
            variable.setChildren(variables);
            return Collections.singletonList(variable);
        }));
    }

    public Flux<Variable> createVariables(List<TermColumn> columns, Integer branchIndex, Integer branchGroupIndex, Integer actionIndex, DeviceRegistry registry) {
        Flux variables = this.createSceneVariables(columns);
        if (branchIndex == null && !this.parallel && actionIndex != null && CollectionUtils.isNotEmpty(this.actions)) {
            for (int i = 0; i < Math.min(this.actions.size(), actionIndex + 1); ++i) {
                variables = variables.concatWith(this.actions.get(i).createVariables(registry, null, branchGroupIndex, i + 1));
            }
        }
        if (branchIndex != null && branchGroupIndex != null && CollectionUtils.isNotEmpty(this.branches) && this.branches.size() > branchIndex) {
            List<SceneAction> actionList;
            SceneActions then;
            SceneConditionAction branch = this.branches.get(branchIndex);
            SceneActions sceneActions = then = branch.getThen() != null && branch.getThen().size() > branchGroupIndex ? branch.getThen().get(branchGroupIndex) : null;
            if (then != null && !then.isParallel() && CollectionUtils.isNotEmpty(actionList = then.getActions())) {
                for (int i = 0; i < Math.min(actionList.size(), actionIndex + 1); ++i) {
                    variables = variables.concatWith(actionList.get(i).createVariables(registry, branchIndex + 1, branchGroupIndex + 1, i + 1));
                }
            }
        }
        return variables.doOnNext(Variable::refactorPrefix);
    }

    static String createBranchActionId(int branchIndex, int groupId, int actionIndex) {
        return "branch_" + branchIndex + "_group_" + groupId + "_action_" + actionIndex;
    }

    public Disposable createBranchHandler(Flux<Map<String, Object>> sourceData, Function3<Integer, String, Map<String, Object>, Mono<Void>> output) {
        if (CollectionUtils.isEmpty(this.branches)) {
            return Disposables.disposed();
        }
        Function<Map, Mono> last = null;
        Disposable.Composite disposable = Disposables.composite();
        int branchIndex = 0;
        for (SceneConditionAction branch : this.branches) {
            int _branchIndex = ++branchIndex;
            Function<Map<String, Object>, Mono<Boolean>> filter = this.createFilter(branch.getWhen());
            ArrayList<Function<Map, Mono>> outs = new ArrayList<Function<Map, Mono>>();
            List<SceneActions> groups = branch.getThen();
            int thenIndex = 0;
            if (CollectionUtils.isNotEmpty(groups)) {
                ++thenIndex;
                for (SceneActions then : groups) {
                    Function<Map, Mono> out2;
                    int size = then.getActions().size();
                    if (!then.isParallel() || size == 1) {
                        String nodeId = SceneRule.createBranchActionId(_branchIndex, thenIndex, 1);
                        out2 = data -> (Mono)output.apply((Object)_branchIndex, (Object)nodeId, data);
                    } else {
                        Object[] nodeIds = new String[size];
                        for (int i = 0; i < nodeIds.length; ++i) {
                            nodeIds[i] = SceneRule.createBranchActionId(_branchIndex, thenIndex, 1 + (i + 1));
                        }
                        Flux nodeIdFlux = Flux.fromArray((Object[])nodeIds);
                        out2 = data -> nodeIdFlux.flatMap(nodeId -> (Mono)output.apply((Object)_branchIndex, nodeId, data)).then();
                    }
                    ShakeLimit shakeLimit = branch.getShakeLimit();
                    if (shakeLimit != null && shakeLimit.isEnabled()) {
                        Sinks.Many sinks = Sinks.many().unicast().onBackpressureBuffer((Queue)Queues.unboundedMultiproducer().get());
                        ShakeLimitGrouping<Map<String, Object>> grouping = this.createGrouping();
                        Function<Map, Mono> handler = out2;
                        disposable.add(shakeLimit.transfer(sinks.asFlux(), (duration, stream) -> grouping.group((Flux<Map<String, Object>>)stream).flatMap(group -> group.window(duration), Integer.MAX_VALUE), (map, total) -> map.put("_total", total)).flatMap(handler).subscribe());
                        out2 = data -> {
                            sinks.emitNext(data, Reactors.emitFailureHandler());
                            return Mono.empty();
                        };
                    }
                    outs.add(out2);
                }
            }
            Flux outFlux = Flux.fromIterable(outs);
            Function<Map, Mono> fOut = out -> outFlux.flatMap(fun -> (Mono)fun.apply(out)).then();
            Function<Map, Mono> handler = data -> ((Mono)filter.apply((Map<String, Object>)data)).flatMap(match -> {
                if (match.booleanValue()) {
                    return ((Mono)fOut.apply((Map)data)).thenReturn((Object)true);
                }
                return Reactors.ALWAYS_FALSE;
            });
            if (last == null) {
                last = handler;
                continue;
            }
            Function<Map, Mono> _last = last;
            last = data -> ((Mono)_last.apply((Map)data)).flatMap(match -> {
                if (match.booleanValue()) {
                    return Reactors.ALWAYS_FALSE;
                }
                return (Mono)handler.apply((Map)data);
            });
        }
        if (last == null) {
            disposable.dispose();
            throw new IllegalArgumentException();
        }
        disposable.add(sourceData.flatMap(last).subscribe());
        return disposable;
    }

    public List<Variable> createDefaultVariable() {
        return this.trigger != null ? this.trigger.createDefaultVariable() : Collections.emptyList();
    }

    public SceneRule where(String expression) {
        this.setTerms(TermExpressionParser.parse((String)expression));
        return this;
    }

    public RuleModel toModel() {
        this.validate();
        RuleModel model = new RuleModel();
        model.setId(this.id);
        model.setName(this.name);
        model.setType(CONTEXT_KEY_SCENE_OUTPUT);
        RuleNodeModel sceneNode = new RuleNodeModel();
        sceneNode.setId(this.id);
        sceneNode.setName(this.name);
        sceneNode.setConfiguration((Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]));
        sceneNode.setExecutor(CONTEXT_KEY_SCENE_OUTPUT);
        sceneNode.addConfiguration("record_data_to_header", (Object)true);
        sceneNode.addConfiguration("record_data_to_header_key", (Object)CONTEXT_KEY_SCENE_OUTPUT);
        this.trigger.applyModel(model, sceneNode);
        model.getNodes().add(sceneNode);
        if (CollectionUtils.isNotEmpty(this.actions)) {
            int index = 1;
            RuleNodeModel preNode = null;
            SceneAction preAction = null;
            for (SceneAction action : this.actions) {
                RuleNodeModel actionNode = new RuleNodeModel();
                actionNode.setId("action_" + index);
                actionNode.setName("\u52a8\u4f5c_" + index);
                action.applyNode(actionNode);
                if (this.parallel) {
                    model.link(sceneNode, actionNode);
                } else {
                    actionNode.addConfiguration("record_data_to_header", (Object)true);
                    actionNode.addConfiguration("record_data_to_header_key", (Object)actionNode.getId());
                    if (preNode == null) {
                        preNode = actionNode;
                        model.link(sceneNode, preNode);
                    } else {
                        RuleLink link = model.link(preNode, actionNode);
                        if (CollectionUtils.isNotEmpty(preAction.getTerms())) {
                            link.setCondition(TermsConditionEvaluator.createCondition(this.trigger.refactorTerm("this", preAction.getTerms())));
                        }
                        preNode = actionNode;
                    }
                }
                model.getNodes().add(actionNode);
                preAction = action;
                ++index;
            }
        }
        if (CollectionUtils.isNotEmpty(this.branches)) {
            int branchIndex = 0;
            for (SceneConditionAction branch : this.branches) {
                ++branchIndex;
                List<SceneActions> group = branch.getThen();
                if (!CollectionUtils.isNotEmpty(group)) continue;
                int groupIndex = 0;
                for (SceneActions actions : group) {
                    ++groupIndex;
                    if (actions == null || !CollectionUtils.isNotEmpty(actions.getActions())) continue;
                    int actionIndex = 1;
                    RuleNodeModel preNode = null;
                    SceneAction preAction = null;
                    for (SceneAction action : actions.getActions()) {
                        RuleNodeModel actionNode = new RuleNodeModel();
                        actionNode.setId(SceneRule.createBranchActionId(branchIndex, groupIndex, actionIndex));
                        actionNode.setName("\u6761\u4ef6" + branchIndex + "_\u5206\u7ec4" + groupIndex + "_\u52a8\u4f5c" + actionIndex);
                        action.applyNode(actionNode);
                        if (!actions.isParallel()) {
                            actionNode.addConfiguration("record_data_to_header", (Object)true);
                            actionNode.addConfiguration("record_data_to_header_key", (Object)actionNode.getId());
                            actionNode.addConfiguration(ACTION_KEY_BRANCH_INDEX, (Object)branchIndex);
                            actionNode.addConfiguration(ACTION_KEY_GROUP_INDEX, (Object)groupIndex);
                            actionNode.addConfiguration(ACTION_KEY_ACTION_INDEX, (Object)actionIndex);
                            if (preNode != null) {
                                RuleLink link = model.link(preNode, actionNode);
                                if (CollectionUtils.isNotEmpty(preAction.getTerms())) {
                                    link.setCondition(TermsConditionEvaluator.createCondition(this.trigger.refactorTerm("this", preAction.getTerms())));
                                }
                            } else if (this.trigger.getType() == TriggerType.manual) {
                                model.link(sceneNode, actionNode);
                            }
                            preNode = actionNode;
                        } else if (this.trigger.getType() == TriggerType.manual) {
                            model.link(sceneNode, actionNode);
                        }
                        model.getNodes().add(actionNode);
                        preAction = action;
                        ++actionIndex;
                    }
                }
            }
        }
        return model;
    }

    public void validate() {
        ValidatorUtils.tryValidate((Object)this, (Class[])new Class[0]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @NotNull(message="error.scene_rule_trigger_cannot_be_null")
    public @NotNull(message="error.scene_rule_trigger_cannot_be_null") Trigger getTrigger() {
        return this.trigger;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public List<SceneAction> getActions() {
        return this.actions;
    }

    public List<SceneConditionAction> getBranches() {
        return this.branches;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTrigger(@NotNull(message="error.scene_rule_trigger_cannot_be_null") @NotNull(message="error.scene_rule_trigger_cannot_be_null") Trigger trigger) {
        this.trigger = trigger;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setActions(List<SceneAction> actions) {
        this.actions = actions;
    }

    public void setBranches(List<SceneConditionAction> branches) {
        this.branches = branches;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

