/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.measurement;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import org.hswebframework.ezorm.core.dsl.Query;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.rule.engine.measurement.AlarmTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import reactor.core.publisher.Flux;

public class AlarmRecordRankMeasurement
extends StaticMeasurement {
    TimeSeriesManager timeSeriesManager;
    static ConfigMetadata aggConfigMetadata = new DefaultConfigMetadata().add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)StringType.GLOBAL).add("agg", "\u805a\u5408\u7c7b\u578b", "count,sum,avg,max,min", (DataType)StringType.GLOBAL).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)StringType.GLOBAL).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)StringType.GLOBAL).add("from", "\u65f6\u95f4\u4ece", "", (DataType)StringType.GLOBAL).add("to", "\u65f6\u95f4\u81f3", "", (DataType)StringType.GLOBAL);

    public AlarmRecordRankMeasurement(TimeSeriesManager timeSeriesManager) {
        super(MeasurementDefinition.of((String)"rank", (String)"\u544a\u8b66\u8bb0\u5f55\u6392\u540d"));
        this.timeSeriesManager = timeSeriesManager;
        this.addDimension(new AggRecordRankDimension());
    }

    class AggRecordRankDimension
    implements MeasurementDimension {
        AggRecordRankDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return IntType.GLOBAL;
        }

        public ConfigMetadata getParams() {
            return aggConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public AggregationQueryParam createQueryParam(MeasurementParameter parameter) {
            return AggregationQueryParam.of().groupBy(parameter.getString("group", "targetId")).sum("count", "count").agg("targetId", Aggregation.TOP).filter(query -> {
                Query cfr_ignored_0 = (Query)((Query)query.where("name", (Object)"record-agg")).where("targetType", (Object)parameter.getString("targetType", null));
            }).limit(parameter.getInt("limit").orElse(1).intValue()).from(parameter.getDate("from").orElseGet(() -> Date.from(LocalDateTime.now().plusDays(-1L).atZone(ZoneId.systemDefault()).toInstant()))).to(parameter.getDate("to").orElse(new Date()));
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            Comparator<AggregationData> comparator = Objects.equals(parameter.getString("order", ""), "asc") ? Comparator.comparingLong(d -> d.getLong("count", 0L)) : Comparator.comparingLong(d -> d.getLong("count", 0L)).reversed();
            AggregationQueryParam param = this.createQueryParam(parameter);
            return Flux.defer(() -> ((Flux)param.execute(arg_0 -> ((TimeSeriesService)AlarmRecordRankMeasurement.this.timeSeriesManager.getService(AlarmTimeSeriesMetric.alarmStreamMetrics())).aggregation(arg_0))).groupBy(a -> a.getString("targetId", null)).flatMap(fluxGroup -> fluxGroup.reduce(AggregationData::merge)).sort(comparator).map(data -> SimpleMeasurementValue.of((Object)new SimpleResult((AggregationData)data), (long)0L))).take((long)param.getLimit());
        }

        class SimpleResult {
            private String targetId;
            private String targetName;
            private long count;

            public SimpleResult(AggregationData data) {
                String targetId = data.getString("targetId", "");
                this.setCount(data.getLong("count", 0L));
                this.setTargetName(data.getString("targetName", targetId));
                this.setTargetId(data.getString("targetId", ""));
            }

            public String getTargetId() {
                return this.targetId;
            }

            public String getTargetName() {
                return this.targetName;
            }

            public long getCount() {
                return this.count;
            }

            public void setTargetId(String targetId) {
                this.targetId = targetId;
            }

            public void setTargetName(String targetName) {
                this.targetName = targetName;
            }

            public void setCount(long count) {
                this.count = count;
            }

            public SimpleResult(String targetId, String targetName, long count) {
                this.targetId = targetId;
                this.targetName = targetName;
                this.count = count;
            }

            public SimpleResult() {
            }
        }
    }
}

