/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.alarm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.rule.engine.alarm.AlarmData;
import org.jetlinks.community.rule.engine.alarm.AlarmTarget;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetInfo;
import org.jetlinks.community.rule.engine.entity.AlarmConfigEntity;
import org.jetlinks.community.rule.engine.entity.AlarmHistoryInfo;
import org.jetlinks.community.rule.engine.entity.AlarmRecordEntity;
import org.jetlinks.community.rule.engine.enums.AlarmRecordState;
import org.jetlinks.community.rule.engine.enums.AlarmState;
import org.jetlinks.community.rule.engine.scene.SceneData;
import org.jetlinks.community.rule.engine.scene.SceneFilter;
import org.jetlinks.community.rule.engine.service.AlarmConfigService;
import org.jetlinks.community.rule.engine.service.AlarmHistoryService;
import org.jetlinks.community.rule.engine.service.AlarmRecordService;
import org.jetlinks.community.topic.Topics;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.reactivestreams.Publisher;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Deprecated
public class AlarmSceneHandler
implements SceneFilter,
CommandLineRunner {
    private final EventBus eventBus;
    private final AlarmConfigService alarmConfigService;
    private final AlarmRecordService alarmRecordService;
    private final AlarmHistoryService alarmHistoryService;
    private final ApplicationEventPublisher publisher;
    private final Map<String, Map<String, AlarmConfigEntity>> alarmConfigCache = new ConcurrentHashMap<String, Map<String, AlarmConfigEntity>>(16);

    @Override
    public Mono<Boolean> filter(SceneData data) {
        Map<String, AlarmConfigEntity> alarmConfigMap = this.alarmConfigCache.get(data.getRule().getId());
        if (alarmConfigMap != null) {
            return Flux.fromIterable(alarmConfigMap.values()).flatMap(alarmConfig -> AlarmTarget.of(alarmConfig.getTargetType()).convert(AlarmData.of((String)alarmConfig.getId(), alarmConfig.getName(), data.getRule().getId(), data.getRule().getName(), data.getOutput())).flatMap(targetInfo -> {
                AlarmRecordEntity record = this.ofRecord((AlarmTargetInfo)targetInfo, (AlarmConfigEntity)((Object)alarmConfig));
                return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.alarmRecordService.createUpdate().set((Object)record)).where(GenericEntity::getId, record.getId())).and(AlarmRecordEntity::getState, (Object)AlarmRecordState.warning)).execute().flatMap(warningRecordCount -> {
                    if (warningRecordCount == 0) {
                        return this.alarmRecordService.save((Object)record).thenReturn(warningRecordCount);
                    }
                    return Mono.just((Object)warningRecordCount);
                }).flatMap(warningRecordCount -> {
                    AlarmHistoryInfo alarmHistoryInfo = AlarmHistoryInfo.of((String)record.getId(), targetInfo, data, alarmConfig);
                    this.publisher.publishEvent((Object)alarmHistoryInfo);
                    return this.alarmHistoryService.save(alarmHistoryInfo).then(Mono.defer(() -> warningRecordCount == 0 ? this.publishAlarmRecord(alarmHistoryInfo, (AlarmConfigEntity)((Object)alarmConfig)) : Mono.empty()));
                });
            })).then().thenReturn((Object)true);
        }
        return Mono.empty();
    }

    public Mono<Void> publishAlarmRecord(AlarmHistoryInfo record, AlarmConfigEntity config) {
        String topic = Topics.alarm((String)record.getTargetType(), (String)record.getTargetId(), (String)record.getAlarmConfigId());
        return this.eventBus.publish(topic, (Object)record).then();
    }

    @Subscribe(value={"/_sys/alarm/config/deleted"}, features={Subscription.Feature.broker})
    public Mono<Void> HandleAlarmConfigDelete(AlarmConfigEntity alarmConfig) {
        return this.doAlarmConfigDelete(alarmConfig);
    }

    @Subscribe(value={"/_sys/alarm/config/created,saved,modified"}, features={Subscription.Feature.broker})
    public Mono<Void> handleAlarmConfigCRU(AlarmConfigEntity alarmConfig) {
        return this.doAlarmConfigCRU(alarmConfig);
    }

    @EventListener
    public void handleAlarmConfigCreated(EntityCreatedEvent<AlarmConfigEntity> event) {
        event.async((Publisher)Mono.defer(() -> Flux.fromIterable((Iterable)event.getEntity()).flatMap(config -> this.handleAlarmConfigCRU("/_sys/alarm/config/created", (AlarmConfigEntity)((Object)((Object)config)))).then()));
    }

    @EventListener
    public void handleAlarmConfigModify(EntityModifyEvent<AlarmConfigEntity> event) {
        Map beforeMap = event.getBefore().stream().collect(Collectors.toMap(GenericEntity::getId, Function.identity()));
        event.async((Publisher)Flux.fromIterable((Iterable)event.getAfter()).flatMap(config -> this.handleAlarmConfigCRU("/_sys/alarm/config/modified", (AlarmConfigEntity)((Object)config)).thenReturn((Object)config)).filter(config -> {
            AlarmConfigEntity before = (AlarmConfigEntity)((Object)((Object)beforeMap.get(config.getId())));
            return before == null || !StringUtils.hasText((String)before.getName()) || !before.getName().equals(config.getName()) || before.getLevel() == null || !before.getLevel().equals(config.getLevel());
        }).flatMap(this::updateAlarmRecord).then());
    }

    @EventListener
    public void handleAlarmConfigSaved(EntitySavedEvent<AlarmConfigEntity> event) {
        event.async((Publisher)Mono.defer(() -> Flux.fromIterable((Iterable)event.getEntity()).flatMap(config -> this.handleAlarmConfigCRU("/_sys/alarm/config/saved", (AlarmConfigEntity)((Object)((Object)config))).then(this.updateAlarmRecord((AlarmConfigEntity)((Object)((Object)config))))).then()));
    }

    @EventListener
    public void beforeAlarmConfigDelete(EntityBeforeDeleteEvent<AlarmConfigEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(e -> ((ReactiveQuery)((ReactiveQuery)this.alarmRecordService.createQuery().where(AlarmRecordEntity::getAlarmConfigId, e.getId())).and(AlarmRecordEntity::getState, (Object)AlarmRecordState.warning)).count().doOnNext(i -> {
            if (i > 0) {
                throw new BusinessException("error.cannot_delete_alarm_config_with_warnning_record");
            }
        })));
    }

    @EventListener
    public void handleAlarmConfigDelete(EntityDeletedEvent<AlarmConfigEntity> event) {
        event.async((Publisher)Mono.defer(() -> Flux.fromIterable((Iterable)event.getEntity()).flatMap(this::handleAlarmConfigDelete).then()));
    }

    private Mono<Void> handleAlarmConfigCRU(String topic, AlarmConfigEntity config) {
        if (AlarmState.enabled.equals((Object)config.getState())) {
            return this.doAlarmConfigCRU(config).then(this.eventBus.publish(topic, (Object)config)).then();
        }
        return this.handleAlarmConfigDelete(config);
    }

    private Mono<Void> handleAlarmConfigDelete(AlarmConfigEntity alarmConfig) {
        return this.doAlarmConfigDelete(alarmConfig).then(this.eventBus.publish("/_sys/alarm/config/deleted", (Object)alarmConfig)).then();
    }

    private Mono<Void> doAlarmConfigCRU(AlarmConfigEntity alarmConfig) {
        if (StringUtils.hasText((String)alarmConfig.getSceneId())) {
            this.alarmConfigCache.computeIfAbsent(alarmConfig.getSceneId(), k -> new ConcurrentHashMap()).put(alarmConfig.getId(), alarmConfig);
        }
        return Mono.empty();
    }

    private Mono<Void> doAlarmConfigDelete(AlarmConfigEntity alarmConfig) {
        if (StringUtils.hasText((String)alarmConfig.getSceneId())) {
            this.alarmConfigCache.compute(alarmConfig.getSceneId(), (k, v) -> {
                if (v != null) {
                    v.remove(alarmConfig.getId());
                    if (v.size() == 0) {
                        return null;
                    }
                }
                return v;
            });
        }
        return Mono.empty();
    }

    private AlarmRecordEntity ofRecord(AlarmTargetInfo targetInfo, AlarmConfigEntity alarmConfigEntity) {
        AlarmRecordEntity entity = new AlarmRecordEntity();
        entity.setAlarmConfigId((String)alarmConfigEntity.getId());
        entity.setState(AlarmRecordState.warning);
        entity.setAlarmTime(System.currentTimeMillis());
        entity.setLevel(alarmConfigEntity.getLevel());
        entity.setTargetType(targetInfo.getTargetType());
        entity.setTargetName(targetInfo.getTargetName());
        entity.setTargetId(targetInfo.getTargetId());
        entity.setAlarmName(alarmConfigEntity.getName());
        entity.setSourceId(targetInfo.getSourceId());
        entity.setSourceType(targetInfo.getSourceType());
        entity.setSourceName(targetInfo.getSourceName());
        entity.generateId();
        return entity;
    }

    private Mono<Integer> updateAlarmRecord(AlarmConfigEntity config) {
        return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.alarmRecordService.createUpdate().set(AlarmRecordEntity::getAlarmName, (Object)config.getName())).set(AlarmRecordEntity::getLevel, (Object)config.getLevel())).where(AlarmRecordEntity::getAlarmConfigId, config.getId())).execute();
    }

    public void run(String ... args) throws Exception {
        ((ReactiveQuery)this.alarmConfigService.createQuery().where(AlarmConfigEntity::getState, (Object)AlarmState.enabled)).fetch().flatMap(this::doAlarmConfigCRU).subscribe();
    }

    public AlarmSceneHandler(EventBus eventBus, AlarmConfigService alarmConfigService, AlarmRecordService alarmRecordService, AlarmHistoryService alarmHistoryService, ApplicationEventPublisher publisher) {
        this.eventBus = eventBus;
        this.alarmConfigService = alarmConfigService;
        this.alarmRecordService = alarmRecordService;
        this.alarmHistoryService = alarmHistoryService;
        this.publisher = publisher;
    }
}

