/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.alarm;

import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetInfo;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import reactor.core.publisher.Flux;

public interface AlarmRuleHandler {
    public Flux<Result> triggered(ExecutionContext var1, RuleData var2);

    public Flux<Result> relieved(ExecutionContext var1, RuleData var2);

    public static class Result {
        @Schema(description="\u544a\u8b66\u914d\u7f6eID")
        private String alarmConfigId;
        @Schema(description="\u544a\u8b66\u540d\u79f0")
        private String alarmName;
        @Schema(description="\u662f\u5426\u91cd\u590d\u544a\u8b66")
        private boolean alarming;
        @Schema(description="\u5f53\u524d\u9996\u6b21\u89e6\u53d1")
        private boolean firstAlarm;
        @Schema(description="\u544a\u8b66\u7ea7\u522b")
        private int level;
        @Schema(description="\u4e0a\u4e00\u6b21\u544a\u8b66\u65f6\u95f4")
        private long lastAlarmTime;
        @Schema(description="\u9996\u6b21\u544a\u8b66\u6216\u8005\u89e3\u9664\u544a\u8b66\u540e\u7684\u518d\u4e00\u6b21\u544a\u8b66\u65f6\u95f4.")
        private long alarmTime;
        @Schema(description="\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
        private String targetType;
        @Schema(description="\u544a\u8b66\u76ee\u6807ID")
        private String targetId;
        @Schema(description="\u544a\u8b66\u76ee\u6807\u540d\u79f0")
        private String targetName;
        @Schema(description="\u544a\u8b66\u6765\u6e90\u7c7b\u578b")
        private String sourceType;
        @Schema(description="\u544a\u8b66\u6765\u6e90ID")
        private String sourceId;
        @Schema(description="\u544a\u8b66\u6765\u6e90\u540d\u79f0")
        private String sourceName;

        public Result copyWith(AlarmTargetInfo targetInfo) {
            Result result = (Result)FastBeanCopier.copy((Object)this, (Object)new Result(), (String[])new String[0]);
            result.setTargetType(targetInfo.getTargetType());
            result.setTargetId(targetInfo.getTargetId());
            result.setTargetName(targetInfo.getTargetName());
            result.setSourceType(targetInfo.getSourceType());
            result.setSourceId(targetInfo.getSourceId());
            result.setSourceName(targetInfo.getSourceName());
            return result;
        }

        public Map<String, Object> toMap() {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("alarmConfigId", this.alarmConfigId);
            map.put("alarmName", this.alarmName);
            map.put("alarming", this.alarming);
            map.put("firstAlarm", this.firstAlarm);
            map.put("level", this.level);
            map.put("alarmTime", this.alarmTime);
            map.put("lastAlarmTime", this.lastAlarmTime);
            map.put("targetType", this.targetType);
            map.put("targetId", this.targetId);
            map.put("targetName", this.targetName);
            map.put("sourceType", this.sourceType);
            map.put("sourceId", this.sourceId);
            map.put("sourceName", this.sourceName);
            return map;
        }

        public String getAlarmConfigId() {
            return this.alarmConfigId;
        }

        public String getAlarmName() {
            return this.alarmName;
        }

        public boolean isAlarming() {
            return this.alarming;
        }

        public boolean isFirstAlarm() {
            return this.firstAlarm;
        }

        public int getLevel() {
            return this.level;
        }

        public long getLastAlarmTime() {
            return this.lastAlarmTime;
        }

        public long getAlarmTime() {
            return this.alarmTime;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public void setAlarmConfigId(String alarmConfigId) {
            this.alarmConfigId = alarmConfigId;
        }

        public void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public void setAlarming(boolean alarming) {
            this.alarming = alarming;
        }

        public void setFirstAlarm(boolean firstAlarm) {
            this.firstAlarm = firstAlarm;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setLastAlarmTime(long lastAlarmTime) {
            this.lastAlarmTime = lastAlarmTime;
        }

        public void setAlarmTime(long alarmTime) {
            this.alarmTime = alarmTime;
        }

        public void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        private Result(String alarmConfigId, String alarmName, boolean alarming, boolean firstAlarm, int level, long lastAlarmTime, long alarmTime, String targetType, String targetId, String targetName, String sourceType, String sourceId, String sourceName) {
            this.alarmConfigId = alarmConfigId;
            this.alarmName = alarmName;
            this.alarming = alarming;
            this.firstAlarm = firstAlarm;
            this.level = level;
            this.lastAlarmTime = lastAlarmTime;
            this.alarmTime = alarmTime;
            this.targetType = targetType;
            this.targetId = targetId;
            this.targetName = targetName;
            this.sourceType = sourceType;
            this.sourceId = sourceId;
            this.sourceName = sourceName;
        }

        public static Result of(String alarmConfigId, String alarmName, boolean alarming, boolean firstAlarm, int level, long lastAlarmTime, long alarmTime, String targetType, String targetId, String targetName, String sourceType, String sourceId, String sourceName) {
            return new Result(alarmConfigId, alarmName, alarming, firstAlarm, level, lastAlarmTime, alarmTime, targetType, targetId, targetName, sourceType, sourceId, sourceName);
        }

        public Result() {
        }
    }
}

