/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl.property;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.jetlinks.community.relation.impl.property.CompositePropertyOperation;
import org.jetlinks.community.relation.impl.property.DetectPropertyOperationStrategy;
import org.jetlinks.community.relation.impl.property.SimplePropertyOperation;
import org.jetlinks.core.things.relation.PropertyOperation;
import reactor.core.publisher.Mono;

public interface PropertyOperationStrategy
extends PropertyOperation {
    public boolean isSupported(String var1);

    public static <T> PropertyOperationStrategy simple(Mono<T> object, Consumer<SimplePropertyOperation<T>> operationConsumer) {
        SimplePropertyOperation<T> strategy = new SimplePropertyOperation<T>(object);
        operationConsumer.accept(strategy);
        return strategy;
    }

    public static PropertyOperationStrategy composite(PropertyOperationStrategy ... strategies) {
        return new CompositePropertyOperation(Arrays.asList(strategies));
    }

    public static PropertyOperationStrategy detect(Map<String, PropertyOperation> operations) {
        return PropertyOperationStrategy.detect((DetectPropertyOperationStrategy detect) -> operations.forEach(detect::addOperation));
    }

    public static PropertyOperationStrategy detect(Consumer<DetectPropertyOperationStrategy> consumer) {
        DetectPropertyOperationStrategy strategy = new DetectPropertyOperationStrategy();
        consumer.accept(strategy);
        return strategy;
    }
}

