/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.utils;

import com.google.common.collect.Maps;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.relation.RelationManagerHolder;
import org.jetlinks.community.relation.utils.VariableObjectSpec;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.reactor.ql.supports.DefaultPropertyFeature;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class VariableSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6765\u6e90")
    private Source source;
    @Schema(description="\u56fa\u5b9a\u503c,[source]\u4e3a[fixed]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private Object value;
    @Schema(description="\u4e0a\u6e38key,[source]\u4e3a[upper]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private String upperKey;
    @Schema(description="\u5173\u7cfb,[source]\u4e3a[relation]\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    private VariableObjectSpec relation;
    @Schema(description="\u62d3\u5c55\u4fe1\u606f")
    private Map<String, Object> options;

    public Map<String, Object> toMap() {
        return (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]);
    }

    public void validate() {
        Assert.notNull((Object)((Object)this.source), (String)"source can not be null");
        switch (this.source) {
            case fixed: {
                Assert.notNull((Object)this.value, (String)"value can not be null");
                break;
            }
            case upper: {
                Assert.hasText((String)this.upperKey, (String)"upperKey can not be empty");
                break;
            }
            case relation: {
                Assert.notNull((Object)((Object)this.relation), (String)"relation can not be null");
                this.relation.validate();
            }
        }
    }

    public static VariableSource fixed(Object value) {
        VariableSource variableSource = new VariableSource();
        variableSource.setSource(Source.fixed);
        variableSource.setValue(value);
        return variableSource;
    }

    public static VariableSource upper(String key) {
        VariableSource variableSource = new VariableSource();
        variableSource.setSource(Source.upper);
        variableSource.setUpperKey(key);
        return variableSource;
    }

    public static VariableSource relation(VariableObjectSpec spec) {
        VariableSource variableSource = new VariableSource();
        variableSource.setSource(Source.relation);
        variableSource.setRelation(spec);
        return variableSource;
    }

    public static VariableSource of(Object value) {
        VariableSource source;
        Map mapVal;
        Object sourceName;
        if (value instanceof VariableSource) {
            return (VariableSource)value;
        }
        if (value instanceof Map && (sourceName = (mapVal = (Map)value).get("source")) != null && Source.of(String.valueOf(sourceName)).isPresent() && (source = (VariableSource)FastBeanCopier.copy((Object)mapVal, (Object)new VariableSource(), (String[])new String[0])).getSource() != null) {
            return source;
        }
        return VariableSource.fixed(value);
    }

    public Flux<Object> resolve(Map<String, Object> context) {
        return this.resolve(context, null);
    }

    public Flux<Object> resolve(Map<String, Object> context, ConfigKey<?> propertyPath) {
        this.validate();
        if (this.getSource() == Source.fixed) {
            return CastUtils.flatStream((Flux)Flux.just((Object)this.value));
        }
        if (this.getSource() == Source.upper) {
            return (Flux)Mono.justOrEmpty((Optional)DefaultPropertyFeature.GLOBAL.getProperty((Object)this.getUpperKey(), context)).flux().as(CastUtils::flatStream);
        }
        if (this.getSource() == Source.relation) {
            VariableObjectSpec objectSpec = this.getRelation();
            objectSpec.init(context);
            return RelationManagerHolder.getObjects(objectSpec).flatMap(obj -> propertyPath == null ? Mono.just((Object)obj.getId()) : obj.properties().get(propertyPath));
        }
        return Flux.empty();
    }

    public Object resolveStatic(Map<String, Object> context) {
        this.validate();
        if (this.getSource() == Source.fixed) {
            return this.value;
        }
        if (this.getSource() == Source.upper) {
            return DefaultPropertyFeature.GLOBAL.getProperty((Object)this.getUpperKey(), context).orElse(null);
        }
        return this.value;
    }

    public static Flux<Object> resolveValue(String key, Map<String, Object> context, ConfigKey<String> relationPropertyPath) {
        Object value = VariableSource.getNestProperty(key, context);
        if (value == null) {
            return Flux.empty();
        }
        return CastUtils.flatStream((Flux)Flux.just((Object)value)).map(VariableSource::of).flatMap(source -> source.resolve(context, relationPropertyPath));
    }

    public static Object resolveValue(String key, Map<String, Object> context) {
        Object value = VariableSource.getNestProperty(key, context);
        if (value == null) {
            return null;
        }
        VariableSource source = VariableSource.of(value);
        if (source.getSource() == Source.fixed) {
            value = source.getValue();
        } else if (source.getSource() == Source.upper) {
            value = VariableSource.getNestProperty(source.getUpperKey(), context);
        } else {
            throw new UnsupportedOperationException("unsupported source type : " + (Object)((Object)source.getSource()));
        }
        return value;
    }

    public static Object getNestProperty(String prop, Map<String, Object> ctx) {
        if (null == prop) {
            return null;
        }
        return DefaultPropertyFeature.GLOBAL.getProperty((Object)prop, ctx).orElse(null);
    }

    public static Map<String, Object> wrap(Map<String, Object> def, Map<String, Object> context) {
        LinkedHashMap vars = Maps.newLinkedHashMapWithExpectedSize((int)def.size());
        for (Map.Entry<String, Object> entry : def.entrySet()) {
            String key = entry.getKey();
            VariableSource source = VariableSource.of(entry.getValue());
            if (source.getSource() == Source.upper) {
                vars.put(key, VariableSource.fixed(VariableSource.getNestProperty(source.getUpperKey(), context)));
                continue;
            }
            vars.put(key, source);
        }
        return vars;
    }

    public Source getSource() {
        return this.source;
    }

    public Object getValue() {
        return this.value;
    }

    public String getUpperKey() {
        return this.upperKey;
    }

    public VariableObjectSpec getRelation() {
        return this.relation;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setUpperKey(String upperKey) {
        this.upperKey = upperKey;
    }

    public void setRelation(VariableObjectSpec relation) {
        this.relation = relation;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public static enum Source {
        fixed,
        upper,
        relation;


        public static Optional<Source> of(String source) {
            for (Source value : Source.values()) {
                if (!value.name().equals(source)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }
}

