/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.wechat.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.annotation.NotifierResource;
import org.jetlinks.community.notify.wechat.corp.CorpDepartment;
import org.jetlinks.community.notify.wechat.corp.CorpTag;
import org.jetlinks.community.notify.wechat.corp.CorpUser;
import org.jetlinks.community.notify.wechat.corp.request.GetDepartmentRequest;
import org.jetlinks.community.notify.wechat.corp.request.GetTagRequest;
import org.jetlinks.community.notify.wechat.corp.request.GetUserRequest;
import org.jetlinks.community.notify.wechat.corp.response.GetDepartmentResponse;
import org.jetlinks.community.notify.wechat.corp.response.GetTagResponse;
import org.jetlinks.community.notify.wechat.corp.response.GetUserResponse;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notifier/wechat/corp"})
@Tag(name="\u4f01\u4e1a\u5fae\u4fe1\u63a5\u53e3")
@NotifierResource
public class WechatCoreNotifierController {
    private final NotifierManager notifierManager;

    @GetMapping(value={"/{configId}/tags"})
    @Operation(summary="\u83b7\u53d6\u5fae\u4fe1\u4f01\u4e1a\u6807\u7b7e\u5217\u8868")
    public Flux<CorpTag> getTagList(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.weixin, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMap(notifier -> (Mono)notifier.execute((Command)new GetTagRequest())).flatMapIterable(GetTagResponse::getTagList);
    }

    @Operation(summary="\u83b7\u53d6\u5fae\u4fe1\u4f01\u4e1a\u90e8\u95e8\u5217\u8868")
    @GetMapping(value={"/{configId}/departments"})
    public Flux<CorpDepartment> getDepartmentList(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.weixin, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMap(notifier -> (Mono)notifier.execute((Command)new GetDepartmentRequest())).flatMapIterable(GetDepartmentResponse::getDepartment);
    }

    @Operation(summary="\u83b7\u53d6\u5fae\u4fe1\u4f01\u4e1a\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/{configId}/{departmentId}/users"})
    public Flux<CorpUser> getCorpUserList(@PathVariable String configId, @PathVariable String departmentId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.weixin, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMap(notifier -> (Mono)notifier.execute((Command)new GetUserRequest(departmentId, false))).flatMapIterable(GetUserResponse::getUserList);
    }

    @Operation(summary="\u83b7\u53d6\u5fae\u4fe1\u4f01\u4e1a\u5168\u90e8\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/{configId}/users"})
    public Flux<CorpUser> getCorpAllUserList(@PathVariable String configId) {
        return this.notifierManager.getNotifier((NotifyType)DefaultNotifyType.weixin, configId).map(notifier -> (CommandSupport)notifier.unwrap(CommandSupport.class)).flatMapMany(notifier -> ((Mono)notifier.execute((Command)new GetDepartmentRequest())).flatMapIterable(GetDepartmentResponse::getDepartment).flatMap(department -> (Mono)notifier.execute((Command)new GetUserRequest(department.getId(), false)))).flatMapIterable(GetUserResponse::getUserList);
    }

    public WechatCoreNotifierController(NotifierManager notifierManager) {
        this.notifierManager = notifierManager;
    }
}

