/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.webhook.http;

import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.Notifier;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.community.notify.webhook.WebHookProvider;
import org.jetlinks.community.notify.webhook.http.HttpWebHookNotifier;
import org.jetlinks.community.notify.webhook.http.HttpWebHookProperties;
import org.jetlinks.community.notify.webhook.http.HttpWebHookTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Component
public class HttpWebHookNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private final TemplateManager templateManager;
    private final WebClient.Builder builder;

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.webhook;
    }

    @Nonnull
    public Provider getProvider() {
        return WebHookProvider.http;
    }

    public Mono<HttpWebHookTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.just((Object)((HttpWebHookTemplate)new HttpWebHookTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public Mono<? extends Notifier<? extends Template>> createNotifier(@Nonnull NotifierProperties properties) {
        HttpWebHookProperties hookProperties = (HttpWebHookProperties)FastBeanCopier.copy((Object)properties.getConfiguration(), (Object)new HttpWebHookProperties(), (String[])new String[0]);
        ValidatorUtils.tryValidate((Object)hookProperties, (Class[])new Class[0]);
        WebClient.Builder client = this.builder.clone();
        client.baseUrl(hookProperties.getUrl());
        return (Mono)Mono.just((Object)((Object)new HttpWebHookNotifier(properties.getId(), hookProperties, client.build(), this.templateManager))).as(LocaleUtils::transform);
    }

    public HttpWebHookNotifierProvider(TemplateManager templateManager, WebClient.Builder builder) {
        this.templateManager = templateManager;
        this.builder = builder;
    }
}

