/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.corp;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.dingtalk.DingTalkProvider;
import org.jetlinks.community.notify.dingtalk.corp.DingTalkMessageTemplate;
import org.jetlinks.community.notify.dingtalk.corp.DingTalkProperties;
import org.jetlinks.community.notify.dingtalk.corp.request.ApiRequest;
import org.jetlinks.community.notify.dingtalk.corp.request.GetAccessTokenRequest;
import org.jetlinks.community.notify.dingtalk.corp.response.AccessTokenResponse;
import org.jetlinks.community.notify.dingtalk.corp.response.ApiResponse;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.relation.RelationConstants;
import org.jetlinks.core.Values;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.config.ConfigKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class DingTalkNotifier
extends AbstractNotifier<DingTalkMessageTemplate>
implements CommandSupport,
ExchangeFilterFunction {
    private static final Logger log = LoggerFactory.getLogger(DingTalkNotifier.class);
    private final WebClient client;
    private final DingTalkProperties properties;
    private volatile Mono<String> token;
    private final String notifierId;

    public DingTalkNotifier(String id, WebClient.Builder client, DingTalkProperties properties, TemplateManager templateManager) {
        super(templateManager);
        this.client = client.clone().baseUrl("https://oapi.dingtalk.com").filter((ExchangeFilterFunction)this).build();
        this.properties = properties;
        this.notifierId = id;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.dingTalk;
    }

    @Nonnull
    public Provider getProvider() {
        return DingTalkProvider.dingTalkMessage;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull DingTalkMessageTemplate template, @Nonnull Values context) {
        String thirdPartyType = this.getType().getId() + "_" + this.getProvider().getId();
        String thirdPartyProvider = this.getNotifierId();
        ConfigKey relationPropertyPath = RelationConstants.UserProperty.thirdParty((String)thirdPartyType, (String)thirdPartyProvider);
        return template.createFormInserter((BodyInserters.FormInserter<String>)BodyInserters.fromFormData((MultiValueMap)new LinkedMultiValueMap()), context, (ConfigKey<String>)relationPropertyPath).flatMap(formInserter -> ((WebClient.RequestBodySpec)this.client.post().uri("/topapi/message/corpconversation/asyncsend_v2", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)formInserter).retrieve().bodyToMono(ApiResponse.class)).then();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mono<String> getToken() {
        if (this.token == null) {
            DingTalkNotifier dingTalkNotifier = this;
            synchronized (dingTalkNotifier) {
                if (this.token == null) {
                    this.token = this.requestToken().cache(val -> Duration.ofSeconds(Math.max(3600, val.getExpiresIn()) - 60), err -> Duration.ZERO, () -> Duration.ZERO).doOnNext(ApiResponse::assertSuccess).map(AccessTokenResponse::getAccessToken);
                }
            }
        }
        return this.token;
    }

    private Mono<AccessTokenResponse> requestToken() {
        return this.execute(new GetAccessTokenRequest(this.properties.getAppKey(), this.properties.getAppSecret()));
    }

    @Nonnull
    public Mono<Void> close() {
        return Mono.empty();
    }

    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        if (command instanceof ApiRequest) {
            return (R)((ApiRequest)command).execute(this.client);
        }
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Mono<ClientResponse> filter(@Nonnull ClientRequest request, @Nonnull ExchangeFunction next) {
        if (request.url().getPath().endsWith("gettoken")) {
            return next.exchange(request);
        }
        return this.getToken().flatMap(token -> next.exchange(ClientRequest.from((ClientRequest)request).url(UriComponentsBuilder.fromUri((URI)request.url()).queryParam("access_token", new Object[]{token}).build().toUri()).build()));
    }

    public String getNotifierId() {
        return this.notifierId;
    }
}

