/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.corp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotBlank;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class DingTalkMessageTemplate
extends AbstractTemplate<DingTalkMessageTemplate> {
    public static final String USER_ID_LIST_KEY = "userIdList";
    public static final String DEPARTMENT_ID_LIST_KEY = "departmentIdList";
    @NotBlank
    private String agentId;
    private String userIdList;
    private String departmentIdList;
    private boolean toAllUser;
    @NotBlank
    private String message;

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        if (this.toAllUser || StringUtils.hasText((String)this.userIdList) || StringUtils.hasText((String)this.departmentIdList)) {
            return Collections.emptyList();
        }
        ArrayList<VariableDefinition> variables = new ArrayList<VariableDefinition>(2);
        variables.add(VariableDefinition.builder().id(USER_ID_LIST_KEY).name("\u6536\u4fe1\u4eba").expand("businessType", (Object)"user").type("string").build());
        variables.add(VariableDefinition.builder().id(DEPARTMENT_ID_LIST_KEY).name("\u6536\u4fe1\u4eba\u90e8\u95e8").expand("businessType", (Object)"org").type("string").build());
        return variables;
    }

    public Mono<BodyInserters.FormInserter<String>> createFormInserter(BodyInserters.FormInserter<String> inserter, Values context, ConfigKey<String> relationPropertyPath) {
        return this.createUserIdList(context, relationPropertyPath).map(userIdList -> {
            String deptIdList;
            inserter.with("agent_id", (Object)this.getAgentId()).with("to_all_user", (Object)String.valueOf(this.toAllUser)).with("msg", (Object)this.createMessage(context));
            if (StringUtils.hasText((String)userIdList)) {
                inserter.with("userid_list", userIdList);
            }
            if (StringUtils.hasText((String)(deptIdList = this.createDepartmentIdList(context)))) {
                inserter.with("dept_id_list", (Object)deptIdList);
            }
            return inserter;
        });
    }

    public Mono<UriComponentsBuilder> createUriParameter(UriComponentsBuilder builder, Values context, ConfigKey<String> relationPropertyPath) {
        return this.createUserIdList(context, relationPropertyPath).map(userIdList -> {
            String deptIdList;
            builder.queryParam("agent_id", new Object[]{this.getAgentId()}).queryParam("to_all_user", new Object[]{String.valueOf(this.toAllUser)}).queryParam("msg", new Object[]{this.createMessage(context)});
            if (StringUtils.hasText((String)userIdList)) {
                builder.queryParam("userid_list", new Object[]{userIdList});
            }
            if (StringUtils.hasText((String)(deptIdList = this.createDepartmentIdList(context)))) {
                builder.queryParam("dept_id_list", new Object[]{deptIdList});
            }
            return builder;
        });
    }

    public Mono<String> createUserIdList(Values context, ConfigKey<String> relationPropertyPath) {
        return VariableSource.resolveValue((String)USER_ID_LIST_KEY, (Map)context.getAllValues(), relationPropertyPath).map(String::valueOf).defaultIfEmpty((Object)(this.userIdList == null ? "" : this.userIdList)).collect(Collectors.joining(","));
    }

    public String createDepartmentIdList(Values context) {
        return this.get(this.getDepartmentIdList(), DEPARTMENT_ID_LIST_KEY, context.getAllValues());
    }

    public String createMessage(Values context) {
        JSONObject json = new JSONObject();
        json.put("msgtype", (Object)"text");
        json.put("text", Collections.singletonMap("content", this.render(this.message, context.getAllValues())));
        return json.toJSONString();
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getUserIdList() {
        return this.userIdList;
    }

    public String getDepartmentIdList() {
        return this.departmentIdList;
    }

    public boolean isToAllUser() {
        return this.toAllUser;
    }

    public String getMessage() {
        return this.message;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setUserIdList(String userIdList) {
        this.userIdList = userIdList;
    }

    public void setDepartmentIdList(String departmentIdList) {
        this.departmentIdList = departmentIdList;
    }

    public void setToAllUser(boolean toAllUser) {
        this.toAllUser = toAllUser;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

