/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.dingtalk.corp.request;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.notify.dingtalk.corp.CorpDepartment;
import org.jetlinks.community.notify.dingtalk.corp.request.ApiRequest;
import org.jetlinks.community.notify.dingtalk.corp.response.ApiResponse;
import org.reactivestreams.Publisher;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GetDepartmentRequest
extends ApiRequest<Flux<CorpDepartment>> {
    private final String departmentId;
    private final boolean fetchChild;

    public GetDepartmentRequest() {
        this(null, true);
    }

    public GetDepartmentRequest(boolean fetchChild) {
        this(null, fetchChild);
    }

    @Override
    public Flux<CorpDepartment> execute(WebClient client) {
        return this.doRequest(this.departmentId, client).flatMapIterable(Response::getResult);
    }

    private Flux<Response> doRequest(String departmentId, WebClient client) {
        return ((WebClient.RequestBodySpec)client.post().uri("/topapi/v2/department/listsub", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((BodyInserter)(StringUtils.hasText((String)departmentId) ? BodyInserters.fromFormData((String)"dept_id", (String)departmentId) : BodyInserters.empty())).retrieve().bodyToMono(Response.class).flatMapMany(response -> {
            response.assertSuccess();
            if (this.fetchChild && CollectionUtils.isNotEmpty(response.getResult())) {
                return Flux.concat((Publisher[])new Publisher[]{Mono.just((Object)response), Flux.fromIterable(response.getResult()).filter(dep -> StringUtils.hasText((String)dep.getId())).flatMap(dep -> this.doRequest(dep.getId(), client))});
            }
            return Mono.just((Object)response);
        });
    }

    public GetDepartmentRequest(String departmentId, boolean fetchChild) {
        this.departmentId = departmentId;
        this.fetchChild = fetchChild;
    }

    public static class Response
    extends ApiResponse {
        @JsonProperty
        @JsonAlias(value={"result"})
        private List<CorpDepartment> result;

        public List<CorpDepartment> getResult() {
            return this.result == null ? Collections.emptyList() : this.result;
        }

        @JsonProperty
        @JsonAlias(value={"result"})
        public void setResult(List<CorpDepartment> result) {
            this.result = result;
        }
    }
}

