/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.sms.aliyun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsSignListRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsSignListResponse;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsTemplateListRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySmsTemplateListResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.logger.ReactiveLogger;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.sms.SmsProvider;
import org.jetlinks.community.notify.sms.aliyun.AliyunSmsTemplate;
import org.jetlinks.community.notify.sms.aliyun.expansion.AliyunSmsExpansion;
import org.jetlinks.community.notify.sms.aliyun.expansion.SmsSign;
import org.jetlinks.community.notify.sms.aliyun.expansion.SmsTemplate;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.core.Values;
import org.jetlinks.core.trace.FluxTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AliyunSmsNotifier
extends AbstractNotifier<AliyunSmsTemplate> {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsNotifier.class);
    private final IAcsClient client;
    private final int connectTimeout = 1000;
    private final int readTimeout = 5000;
    private String notifierId;
    private String domain = "dysmsapi.aliyuncs.com";
    private String regionId = "cn-hangzhou";

    public AliyunSmsNotifier(NotifierProperties profile, TemplateManager templateManager) {
        super(templateManager);
        this.regionId = (String)profile.getString("regionId").orElseThrow(() -> new IllegalArgumentException("[regionId]\u4e0d\u80fd\u4e3a\u7a7a"));
        String accessKeyId = (String)profile.getString("accessKeyId").orElseThrow(() -> new IllegalArgumentException("[accessKeyId]\u4e0d\u80fd\u4e3a\u7a7a"));
        String secret = (String)profile.getString("secret").orElseThrow(() -> new IllegalArgumentException("[secret]\u4e0d\u80fd\u4e3a\u7a7a"));
        this.domain = profile.getString("domain", this.domain);
        DefaultProfile defaultProfile = DefaultProfile.getProfile((String)this.regionId, (String)accessKeyId, (String)secret);
        this.client = new DefaultAcsClient((IClientProfile)defaultProfile);
        this.notifierId = profile.getId();
    }

    public AliyunSmsNotifier(IClientProfile profile, TemplateManager templateManager) {
        this((IAcsClient)new DefaultAcsClient(profile), templateManager);
    }

    public AliyunSmsNotifier(IAcsClient client, TemplateManager templateManager) {
        super(templateManager);
        this.client = client;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.sms;
    }

    @Nonnull
    public Provider getProvider() {
        return SmsProvider.aliyunSms;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull AliyunSmsTemplate template, @Nonnull Values context) {
        Map ctx = context.getAllValues();
        return template.getPhoneNumber(ctx).collect(Collectors.joining(",")).filter(StringUtils::hasText).flatMap(phoneNumber -> {
            try {
                CommonRequest request = new CommonRequest();
                request.setSysMethod(MethodType.POST);
                request.setSysDomain(this.domain);
                request.setSysVersion("2017-05-25");
                request.setSysAction("SendSms");
                request.setSysConnectTimeout(Integer.valueOf(1000));
                request.setSysReadTimeout(Integer.valueOf(5000));
                request.putQueryParameter("RegionId", this.regionId);
                request.putQueryParameter("PhoneNumbers", phoneNumber);
                request.putQueryParameter("SignName", template.getSignName(ctx));
                request.putQueryParameter("TemplateCode", template.getCode(ctx));
                request.putQueryParameter("TemplateParam", template.createTtsParam(ctx));
                CommonResponse response = this.client.getCommonResponse(request);
                log.info("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5b8c\u6210 {}:{}", (Object)response.getHttpResponse().getStatus(), (Object)response.getData());
                JSONObject json = JSON.parseObject((String)response.getData());
                if (!"ok".equalsIgnoreCase(json.getString("Code"))) {
                    return Mono.error((Throwable)new BusinessException(json.getString("Message"), json.getString("Code")));
                }
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            return Mono.empty();
        }).doOnEach(ReactiveLogger.onError(err -> log.info("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u5931\u8d25", err))).subscribeOn(Schedulers.boundedElastic()).then();
    }

    @Nonnull
    public Mono<Void> close() {
        return Mono.fromRunnable(() -> ((IAcsClient)this.client).shutdown());
    }

    public Mono<AliyunSmsExpansion> getSmsExpansion() {
        return Mono.zip((Mono)this.getSmsSigns().collectList(), (Mono)this.getSmsTemplates().collectList(), AliyunSmsExpansion::of).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<SmsSign> getSmsSigns() {
        return ((Flux)this.doQuerySmsSigns(new AtomicInteger(0), 50).flatMapIterable(Function.identity()).map(SmsSign::of).as((Function)FluxTracer.create((String)"/aliyun/sms/sign"))).onErrorResume(err -> Mono.empty());
    }

    public Flux<SmsTemplate> getSmsTemplates() {
        return ((Flux)this.doQuerySmsTemplates(new AtomicInteger(0), 50).flatMapIterable(Function.identity()).map(SmsTemplate::of).as((Function)FluxTracer.create((String)"/aliyun/sms/template"))).onErrorResume(err -> Mono.empty());
    }

    public Flux<List<QuerySmsSignListResponse.QuerySmsSignDTO>> doQuerySmsSigns(AtomicInteger pageIndex, int pageSize) {
        QuerySmsSignListRequest request = new QuerySmsSignListRequest();
        request.setPageSize(Integer.valueOf(pageSize));
        request.setPageIndex(Integer.valueOf(pageIndex.incrementAndGet()));
        return Mono.fromCallable(() -> ((QuerySmsSignListResponse)this.client.getAcsResponse((AcsRequest)request)).getSmsSignList()).expand(dtos -> {
            if (dtos.size() == pageSize) {
                return this.doQuerySmsSigns(pageIndex, pageSize);
            }
            return Flux.empty();
        });
    }

    public Flux<List<QuerySmsTemplateListResponse.SmsStatsResultDTO>> doQuerySmsTemplates(AtomicInteger pageIndex, int pageSize) {
        QuerySmsTemplateListRequest request = new QuerySmsTemplateListRequest();
        request.setPageSize(Integer.valueOf(pageSize));
        request.setPageIndex(Integer.valueOf(pageIndex.incrementAndGet()));
        return Mono.fromCallable(() -> ((QuerySmsTemplateListResponse)this.client.getAcsResponse((AcsRequest)request)).getSmsTemplateList()).expand(dtos -> {
            if (dtos.size() == pageSize) {
                return this.doQuerySmsTemplates(pageIndex, pageSize);
            }
            return Flux.empty();
        });
    }

    public String getNotifierId() {
        return this.notifierId;
    }
}

