/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web.request;

import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.SimpleMqttMessage;
import org.jetlinks.rule.engine.executor.PayloadType;

public class MqttMessageRequest {
    private String topic;
    private int qosLevel;
    private Object data;
    private int messageId;
    private boolean will;
    private boolean dup;
    private boolean retain;

    public static MqttMessage of(MqttMessageRequest request, PayloadType type) {
        SimpleMqttMessage message = (SimpleMqttMessage)FastBeanCopier.copy((Object)request, (Object)new SimpleMqttMessage(), (String[])new String[0]);
        message.setPayload(type.write(request.getData()));
        return message;
    }

    public static MqttMessageRequest of(MqttMessage message, PayloadType type) {
        MqttMessageRequest requestMessage = new MqttMessageRequest();
        requestMessage.setTopic(message.getTopic());
        requestMessage.setQosLevel(message.getQosLevel());
        requestMessage.setData(type.read(message.getPayload()));
        requestMessage.setWill(message.isWill());
        requestMessage.setDup(message.isDup());
        requestMessage.setRetain(message.isRetain());
        requestMessage.setMessageId(message.getMessageId());
        return requestMessage;
    }

    public static MqttMessageRequestBuilder builder() {
        return new MqttMessageRequestBuilder();
    }

    public MqttMessageRequest(String topic, int qosLevel, Object data, int messageId, boolean will, boolean dup, boolean retain) {
        this.topic = topic;
        this.qosLevel = qosLevel;
        this.data = data;
        this.messageId = messageId;
        this.will = will;
        this.dup = dup;
        this.retain = retain;
    }

    public MqttMessageRequest() {
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQosLevel() {
        return this.qosLevel;
    }

    public Object getData() {
        return this.data;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public boolean isWill() {
        return this.will;
    }

    public boolean isDup() {
        return this.dup;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setQosLevel(int qosLevel) {
        this.qosLevel = qosLevel;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public void setWill(boolean will) {
        this.will = will;
    }

    public void setDup(boolean dup) {
        this.dup = dup;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    public static class MqttMessageRequestBuilder {
        private String topic;
        private int qosLevel;
        private Object data;
        private int messageId;
        private boolean will;
        private boolean dup;
        private boolean retain;

        MqttMessageRequestBuilder() {
        }

        public MqttMessageRequestBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public MqttMessageRequestBuilder qosLevel(int qosLevel) {
            this.qosLevel = qosLevel;
            return this;
        }

        public MqttMessageRequestBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public MqttMessageRequestBuilder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        public MqttMessageRequestBuilder will(boolean will) {
            this.will = will;
            return this;
        }

        public MqttMessageRequestBuilder dup(boolean dup) {
            this.dup = dup;
            return this;
        }

        public MqttMessageRequestBuilder retain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public MqttMessageRequest build() {
            return new MqttMessageRequest(this.topic, this.qosLevel, this.data, this.messageId, this.will, this.dup, this.retain);
        }

        public String toString() {
            return "MqttMessageRequest.MqttMessageRequestBuilder(topic=" + this.topic + ", qosLevel=" + this.qosLevel + ", data=" + this.data + ", messageId=" + this.messageId + ", will=" + this.will + ", dup=" + this.dup + ", retain=" + this.retain + ")";
        }
    }
}

