/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.jetlinks.community.network.resource.NetworkResource;
import org.jetlinks.community.network.resource.NetworkResourceManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/network/resources"})
@Authorize
@Tag(name="\u7f51\u7edc\u8d44\u6e90\u7ba1\u7406")
public class NetworkResourceController {
    private final NetworkResourceManager resourceManager;

    @GetMapping(value={"/alive"})
    @Operation(summary="\u83b7\u53d6\u53ef\u7528\u7684\u8d44\u6e90\u4fe1\u606f")
    public Flux<NetworkResource> getResources() {
        return this.resourceManager.getAliveResources().filter(NetworkResource::hostIsBindAll).groupBy(NetworkResource::getHost).flatMap(group -> {
            String host = (String)group.key();
            return group.reduce((Object)NetworkResource.of((String)host, (Integer[])new Integer[0]), (a, b) -> a.retainPorts(b.getPorts()));
        });
    }

    @GetMapping(value={"/alive/_all"})
    @Operation(summary="\u83b7\u53d6\u5168\u90e8\u96c6\u7fa4\u8282\u70b9\u7684\u8d44\u6e90\u4fe1\u606f")
    public Flux<NetworkResource> getAllResources() {
        return this.resourceManager.getAliveResources();
    }

    @GetMapping(value={"/alive/_current"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u96c6\u7fa4\u8282\u70b9\u7684\u8d44\u6e90\u4fe1\u606f")
    public Flux<NetworkResource> getCurrentAliveResources() {
        return this.resourceManager.getAliveResources();
    }

    public NetworkResourceController(NetworkResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

