/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Objects;
import lombok.Generated;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.operator.dml.query.SortOrder;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.I18nSupportException;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.channel.ChannelInfo;
import org.jetlinks.community.network.manager.entity.NetworkConfigEntity;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;
import org.jetlinks.community.network.manager.service.NetworkChannelProvider;
import org.jetlinks.community.network.manager.service.NetworkConfigService;
import org.jetlinks.community.network.manager.web.response.NetworkTypeInfo;
import org.jetlinks.community.reference.DataReferenceManager;
import org.reactivestreams.Publisher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.bool.BooleanUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/network/config"})
@Resource(id="network-config", name="\u7f51\u7edc\u7ec4\u4ef6\u914d\u7f6e")
@Authorize
@Tag(name="\u7f51\u7edc\u7ec4\u4ef6\u7ba1\u7406")
public class NetworkConfigController
implements ReactiveServiceCrudController<NetworkConfigEntity, String> {
    private final NetworkConfigService configService;
    private final NetworkManager networkManager;
    private final DataReferenceManager referenceManager;
    private final NetworkChannelProvider channelProvider;

    @Generated
    public NetworkConfigService getService() {
        return this.configService;
    }

    @GetMapping(value={"/{networkType}/_detail"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u4e0b\u5168\u90e8\u7684\u7f51\u7edc\u7ec4\u4ef6\u4fe1\u606f")
    public Flux<ChannelInfo> getNetworkInfo(@PathVariable @Parameter(description="\u7f51\u7edc\u7ec4\u4ef6\u7c7b\u578b") String networkType) {
        NetworkProvider provider = (NetworkProvider)this.networkManager.getProvider(networkType).orElseThrow(() -> new I18nSupportException("error.unsupported_network_type", new Object[]{networkType}));
        return ((ReactiveQuery)((ReactiveQuery)this.configService.createQuery().where(NetworkConfigEntity::getType, (Object)networkType)).orderBy(new SortOrder[]{SortOrder.desc(GenericEntity::getId)})).fetch().flatMap(entity -> this.toConfigInfo((NetworkConfigEntity)((Object)entity), (NetworkProvider<?>)provider));
    }

    @GetMapping(value={"/{networkType}/_alive"})
    @QueryAction
    @QueryOperation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u4e0b\u53ef\u7528\u7684\u7f51\u7edc\u7ec4\u4ef6\u4fe1\u606f")
    public Flux<ChannelInfo> getAliveNetworkInfo(@PathVariable @Parameter(description="\u7f51\u7edc\u7ec4\u4ef6\u7c7b\u578b") String networkType, @Parameter(description="\u5305\u542b\u6307\u5b9a\u7684\u7f51\u7edc\u7ec4\u4ef6ID") @RequestParam(required=false) String include, @Parameter(hidden=true) QueryParamEntity query) {
        NetworkProvider provider = (NetworkProvider)this.networkManager.getProvider(networkType).orElseThrow(() -> new I18nSupportException("error.unsupported_network_type", new Object[]{networkType}));
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.configService.createQuery().setParam((QueryParam)query)).where(NetworkConfigEntity::getType, (Object)networkType)).and(NetworkConfigEntity::getState, (Object)NetworkConfigState.enabled)).orderBy(new SortOrder[]{SortOrder.desc(GenericEntity::getId)})).fetch().filterWhen(config -> {
            if (provider.isReusable() || Objects.equals(config.getId(), include)) {
                return Mono.just((Object)true);
            }
            return (Publisher)this.referenceManager.isReferenced("network", (String)config.getId()).as(BooleanUtils::not);
        }).flatMap(entity -> this.toConfigInfo((NetworkConfigEntity)((Object)entity), (NetworkProvider<?>)provider));
    }

    private Mono<ChannelInfo> toConfigInfo(NetworkConfigEntity entity, NetworkProvider<?> provider) {
        return this.channelProvider.toChannelInfo(entity);
    }

    @GetMapping(value={"/supports"})
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u7f51\u7edc\u7ec4\u4ef6\u7c7b\u578b")
    public Flux<NetworkTypeInfo> getSupports() {
        return Flux.fromIterable((Iterable)this.networkManager.getProviders()).map(NetworkProvider::getType).map(NetworkTypeInfo::of);
    }

    @PostMapping(value={"/{id}/_start"})
    @SaveAction
    @Operation(summary="\u542f\u52a8\u7f51\u7edc\u7ec4\u4ef6")
    public Mono<Void> start(@PathVariable @Parameter(description="\u7f51\u7edc\u7ec4\u4ef6ID") String id) {
        return this.configService.start(id);
    }

    @PostMapping(value={"/{id}/_shutdown"})
    @SaveAction
    @Operation(summary="\u505c\u6b62\u7f51\u7edc\u7ec4\u4ef6")
    public Mono<Void> shutdown(@PathVariable @Parameter(description="\u7f51\u7edc\u7ec4\u4ef6ID") String id) {
        return this.configService.shutdown(id);
    }

    public NetworkConfigController(NetworkConfigService configService, NetworkManager networkManager, DataReferenceManager referenceManager, NetworkChannelProvider channelProvider) {
        this.configService = configService;
        this.networkManager = networkManager;
        this.referenceManager = referenceManager;
        this.channelProvider = channelProvider;
    }
}

