/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.network.manager.entity.CertificateEntity;
import org.jetlinks.community.network.manager.service.CertificateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/network/certificate"})
@Authorize
@Resource(id="certificate", name="\u8bc1\u4e66\u7ba1\u7406")
@Tag(name="\u8bc1\u4e66\u7ba1\u7406")
public class CertificateController
implements ReactiveServiceCrudController<CertificateEntity, String> {
    @Autowired
    private CertificateService certificateService;
    @Autowired(required=false)
    DataBufferFactory factory = new DefaultDataBufferFactory();

    public CertificateService getService() {
        return this.certificateService;
    }

    @GetMapping(value={"/{id}/detail"})
    @QueryAction
    @Operation(summary="\u67e5\u770b\u8bc1\u4e66\u4fe1\u606f")
    public Mono<String> getCertificateInfo(@PathVariable String id) {
        return this.certificateService.getCertificate(id).map(Object::toString);
    }

    @SaveAction
    @PostMapping(value={"/upload"})
    @Operation(summary="\u4e0a\u4f20\u8bc1\u4e66\u5e76\u8fd4\u56de\u8bc1\u4e66BASE64")
    public Mono<String> upload(@RequestPart(value="file") @Parameter(name="file", description="\u6587\u4ef6") Part part) {
        if (part instanceof FilePart) {
            return part.content().collectList().flatMap(all -> Mono.fromCallable(() -> Base64.encodeBase64String((byte[])StreamUtils.copyToByteArray((InputStream)this.factory.join(all).asInputStream()))));
        }
        return Mono.error(() -> new IllegalArgumentException("[file] part is not a file"));
    }
}

