/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import java.time.Duration;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.DeviceGatewayManager;
import org.jetlinks.community.network.manager.entity.DeviceGatewayEntity;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;
import org.jetlinks.community.network.manager.service.DeviceGatewayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Order(value=1)
@Component
public class SyncDeviceGatewayState
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SyncDeviceGatewayState.class);
    private final DeviceGatewayService deviceGatewayService;
    private final DeviceGatewayManager deviceGatewayManager;
    private final Duration gatewayStartupDelay = Duration.ofSeconds(5L);

    public SyncDeviceGatewayState(DeviceGatewayService deviceGatewayService, DeviceGatewayManager deviceGatewayManager) {
        this.deviceGatewayService = deviceGatewayService;
        this.deviceGatewayManager = deviceGatewayManager;
    }

    public void run(String ... args) {
        log.debug("start device gateway in {} later", (Object)this.gatewayStartupDelay);
        Mono.delay((Duration)this.gatewayStartupDelay).then(((ReactiveQuery)((ReactiveQuery)this.deviceGatewayService.createQuery().where()).and(DeviceGatewayEntity::getState, (Object)NetworkConfigState.enabled)).fetch().map(GenericEntity::getId).flatMap(arg_0 -> ((DeviceGatewayManager)this.deviceGatewayManager).getGateway(arg_0)).flatMap(DeviceGateway::startup).onErrorContinue((err, obj) -> log.error(err.getMessage(), err)).then()).subscribe();
    }
}

