/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import java.util.Collection;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.manager.entity.CertificateEntity;
import org.jetlinks.community.network.manager.entity.NetworkConfigEntity;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;
import org.jetlinks.community.network.manager.service.NetworkConfigService;
import org.jetlinks.community.reference.DataReferenceManager;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class NetworkEntityEventHandler {
    private final NetworkConfigService networkService;
    private final DataReferenceManager referenceManager;
    private final NetworkManager networkManager;

    @EventListener
    public void handleCertificateDelete(EntityBeforeDeleteEvent<CertificateEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(e -> ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.networkService.createQuery().$like$(NetworkConfigEntity::getConfiguration, e.getId())).or()).$like$(NetworkConfigEntity::getCluster, e.getId())).count().doOnNext(i -> {
            if (i > 0) {
                throw new BusinessException("error.certificate_has_bean_use_by_network");
            }
        })));
    }

    @EventListener
    public void handleNetworkDelete(EntityBeforeDeleteEvent<NetworkConfigEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(e -> this.referenceManager.assertNotReferenced("network", (String)e.getId())));
    }

    @EventListener
    public void handleNetworkCreated(EntityCreatedEvent<NetworkConfigEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMapIterable(NetworkConfigEntity::toNetworkPropertiesList).flatMap(this::networkConfigValidate).then(this.handleEvent(event.getEntity())));
    }

    @EventListener
    public void handleNetworkSaved(EntitySavedEvent<NetworkConfigEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).filter(conf -> conf.getConfiguration() != null || conf.getCluster() != null).flatMapIterable(NetworkConfigEntity::toNetworkPropertiesList).flatMap(this::networkConfigValidate).then(this.handleEvent(event.getEntity())));
    }

    @EventListener
    public void handleNetworkModify(EntityModifyEvent<NetworkConfigEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getAfter()).filter(conf -> conf.getConfiguration() != null || conf.getCluster() != null).flatMapIterable(NetworkConfigEntity::toNetworkPropertiesList).flatMap(this::networkConfigValidate).then(this.handleEvent(event.getAfter())));
    }

    private Mono<Void> networkConfigValidate(NetworkProperties properties) {
        return Mono.justOrEmpty((Optional)this.networkManager.getProvider(properties.getType())).flatMap(networkProvider -> networkProvider.createConfig(properties)).then();
    }

    private Mono<Void> handleEvent(Collection<NetworkConfigEntity> entities) {
        return Flux.fromIterable(entities).filter(conf -> conf.getState() == NetworkConfigState.enabled).flatMap(conf -> this.networkManager.reload(conf.lookupNetworkType(), (String)conf.getId())).then();
    }

    public NetworkEntityEventHandler(NetworkConfigService networkService, DataReferenceManager referenceManager, NetworkManager networkManager) {
        this.networkService = networkService;
        this.referenceManager = referenceManager;
        this.networkManager = networkManager;
    }
}

