/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntityPrepareCreateEvent;
import org.hswebframework.web.crud.events.EntityPrepareModifyEvent;
import org.hswebframework.web.crud.events.EntityPrepareSaveEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.DeviceGatewayManager;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.network.manager.entity.DeviceGatewayEntity;
import org.jetlinks.community.network.manager.enums.DeviceGatewayState;
import org.jetlinks.community.network.manager.service.DeviceGatewayService;
import org.jetlinks.community.reference.DataReferenceManager;
import org.jetlinks.core.ProtocolSupport;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Order(value=1)
@Component
public class DeviceGatewayEventHandler
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DeviceGatewayEventHandler.class);
    public static final String DO_NOT_RELOAD_GATEWAY = "_do_not_reload_device_gateway";
    private final DeviceGatewayService deviceGatewayService;
    private final DeviceGatewayManager deviceGatewayManager;
    private final DataReferenceManager referenceManager;
    private final Duration gatewayStartupDelay = Duration.ofSeconds(5L);

    public DeviceGatewayEventHandler(DeviceGatewayService deviceGatewayService, DeviceGatewayManager deviceGatewayManager, DataReferenceManager referenceManager) {
        this.deviceGatewayService = deviceGatewayService;
        this.deviceGatewayManager = deviceGatewayManager;
        this.referenceManager = referenceManager;
    }

    @EventListener
    public void handlePrepareSave(EntityPrepareSaveEvent<DeviceGatewayEntity> event) {
        this.putGatewayInfo(event.getEntity());
        event.async(this.gatewayConfigValidate(event.getEntity()));
    }

    @EventListener
    public void handlePrepareCreate(EntityPrepareCreateEvent<DeviceGatewayEntity> event) {
        this.putGatewayInfo(event.getEntity());
        event.async(this.gatewayConfigValidate(event.getEntity()));
    }

    @EventListener
    public void handlePrepareUpdate(EntityPrepareModifyEvent<DeviceGatewayEntity> event) {
        this.putGatewayInfo(event.getAfter());
        event.async(this.gatewayConfigValidate(event.getBefore()));
    }

    @EventListener
    public void handleGatewayDelete(EntityBeforeDeleteEvent<DeviceGatewayEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(gateway -> this.referenceManager.assertNotReferenced("device-gateway", (String)gateway.getId())));
    }

    @EventListener
    public void handleCreated(EntityCreatedEvent<DeviceGatewayEntity> event) {
        event.async(this.reloadGateway((Flux<DeviceGatewayEntity>)Flux.fromIterable((Iterable)event.getEntity()).filter(gateway -> gateway.getState() == DeviceGatewayState.enabled)));
    }

    @EventListener
    public void handleSaved(EntitySavedEvent<DeviceGatewayEntity> event) {
        event.async(this.reloadGateway((Flux<DeviceGatewayEntity>)Flux.fromIterable((Iterable)event.getEntity()).filter(gateway -> gateway.getState() == DeviceGatewayState.enabled)));
    }

    @EventListener
    public void handleModify(EntityModifyEvent<DeviceGatewayEntity> event) {
        event.async((Publisher)Mono.deferContextual(ctx -> {
            if (ctx.getOrEmpty((Object)DO_NOT_RELOAD_GATEWAY).isPresent()) {
                return Mono.empty();
            }
            return this.reloadGateway((Flux<DeviceGatewayEntity>)Flux.fromIterable((Iterable)event.getAfter()).filter(gateway -> gateway.getState() == DeviceGatewayState.enabled));
        }));
    }

    private Mono<Void> reloadGateway(Flux<DeviceGatewayEntity> gatewayEntities) {
        return gatewayEntities.flatMap(gateway -> this.deviceGatewayManager.reload((String)gateway.getId())).then();
    }

    private void putGatewayInfo(List<DeviceGatewayEntity> entities) {
        for (DeviceGatewayEntity entity : entities) {
            DeviceGatewayProvider provider = (DeviceGatewayProvider)this.deviceGatewayManager.getProvider(entity.getProvider()).orElseThrow(() -> new UnsupportedOperationException("error.unsupported_device_gateway_provider"));
            if (!StringUtils.hasText((String)((String)entity.getId()))) {
                entity.setId(IDGenerator.SNOW_FLAKE_STRING.generate());
            }
            entity.setChannel(provider.getChannel());
            if (!StringUtils.hasText((String)entity.getTransport())) {
                entity.setTransport(provider.getTransport().getId());
            }
            if (!StringUtils.hasText((String)entity.getChannelId())) {
                entity.setChannelId((String)entity.getId());
            }
            if (!(provider instanceof ProtocolSupport)) continue;
            entity.setProtocol(provider.getId());
        }
    }

    private Mono<Void> gatewayConfigValidate(List<DeviceGatewayEntity> entityList) {
        return Flux.fromIterable(entityList).filter(entity -> entity.getConfiguration() != null).flatMap(entity -> Mono.justOrEmpty((Optional)this.deviceGatewayManager.getProvider(entity.getProvider())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("error.unsupported_device_gateway_provider"))).flatMap(gatewayProvider -> gatewayProvider.createDeviceGateway(entity.toProperties()))).then();
    }

    public void run(String ... args) {
        log.debug("start device gateway in {} later", (Object)this.gatewayStartupDelay);
        Mono.delay((Duration)this.gatewayStartupDelay).then(Mono.defer(() -> ((ReactiveQuery)((ReactiveQuery)this.deviceGatewayService.createQuery().where()).and(DeviceGatewayEntity::getState, (Object)DeviceGatewayState.enabled)).fetch().map(GenericEntity::getId).flatMap(id -> Mono.defer(() -> this.deviceGatewayManager.getGateway(id).flatMap(DeviceGateway::startup)).onErrorResume(err -> {
            log.error(err.getMessage(), err);
            return Mono.empty();
        })).then())).subscribe();
    }
}

