/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.jetlinks.community.gateway.supports.DeviceGatewayProperties;
import org.jetlinks.community.gateway.supports.DeviceGatewayPropertiesManager;
import org.jetlinks.community.network.manager.entity.DeviceGatewayEntity;
import org.jetlinks.community.network.manager.service.DeviceGatewayService;
import org.jetlinks.community.reference.DataReferenceInfo;
import org.jetlinks.community.reference.DataReferenceProvider;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class DeviceGatewayConfigService
implements DeviceGatewayPropertiesManager,
DataReferenceProvider {
    private final DeviceGatewayService deviceGatewayService;

    public String getId() {
        return "network";
    }

    public Flux<DataReferenceInfo> getReference(String networkId) {
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.deviceGatewayService.createQuery().where()).and(DeviceGatewayEntity::getChannel, (Object)"network")).is(DeviceGatewayEntity::getChannelId, (Object)networkId)).fetch().map(e -> DataReferenceInfo.of((String)((String)e.getId()), (String)"network", (String)e.getChannelId(), (String)e.getName()));
    }

    public Flux<DataReferenceInfo> getReferences() {
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.deviceGatewayService.createQuery().where()).and(DeviceGatewayEntity::getChannel, (Object)"network")).notNull(DeviceGatewayEntity::getChannelId)).fetch().map(e -> DataReferenceInfo.of((String)((String)e.getId()), (String)"network", (String)e.getChannelId(), (String)e.getName()));
    }

    public DeviceGatewayConfigService(DeviceGatewayService deviceGatewayService) {
        this.deviceGatewayService = deviceGatewayService;
    }

    public Mono<DeviceGatewayProperties> getProperties(String id) {
        return this.deviceGatewayService.findById(id).map(DeviceGatewayEntity::toProperties);
    }

    public Flux<DeviceGatewayProperties> getPropertiesByChannel(String channel) {
        return ((ReactiveQuery)((ReactiveQuery)this.deviceGatewayService.createQuery().where()).and(DeviceGatewayEntity::getChannel, (Object)channel)).fetch().map(DeviceGatewayEntity::toProperties);
    }
}

