/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.enums;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;
import org.jetlinks.community.network.manager.entity.CertificateEntity;
import org.jetlinks.community.network.security.DefaultCertificate;
import org.springframework.util.StringUtils;

public enum CertificateFormat {
    PFX{

        @Override
        public DefaultCertificate init(DefaultCertificate certificate, CertificateEntity.CertificateConfig config) {
            if (StringUtils.hasText((String)config.getKeystoreBase64())) {
                certificate.initPfxKey(Base64.decodeBase64((String)config.getKeystoreBase64()), config.getKeystorePwd());
            }
            return certificate.initPfxTrust(Base64.decodeBase64((String)config.getTrustKeyStoreBase64()), config.getTrustKeyStorePwd());
        }
    }
    ,
    JKS{

        @Override
        public DefaultCertificate init(DefaultCertificate certificate, CertificateEntity.CertificateConfig config) {
            if (StringUtils.hasText((String)config.getKeystoreBase64())) {
                certificate.initJksKey(Base64.decodeBase64((String)config.getKeystoreBase64()), config.getKeystorePwd());
            }
            return certificate.initJksTrust(Base64.decodeBase64((String)config.getTrustKeyStoreBase64()), config.getTrustKeyStorePwd());
        }
    }
    ,
    PEM{

        @Override
        public DefaultCertificate init(DefaultCertificate certificate, CertificateEntity.CertificateConfig config) {
            if (StringUtils.hasText((String)config.getKey())) {
                byte[] key = this.parseCertBody(config.getKey());
                byte[] cert = StringUtils.hasText((String)config.getCert()) ? this.parseCertBody(config.getCert()) : key;
                certificate.initPemKey(Collections.singletonList(key), Collections.singletonList(cert));
            }
            if (StringUtils.hasText((String)config.getTrust())) {
                certificate.initPemTrust(Collections.singletonList(this.parseCertBody(config.getTrust())));
            }
            return certificate;
        }

        private byte[] parseCertBody(String text) {
            if (text.contains("-")) {
                return text.getBytes(StandardCharsets.UTF_8);
            }
            return Base64.decodeBase64((String)text);
        }
    };


    public abstract DefaultCertificate init(DefaultCertificate var1, CertificateEntity.CertificateConfig var2);
}

