/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.sql.JDBCType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;

@Table(name="network_config")
@Comment(value="\u7f51\u7edc\u7ec4\u4ef6\u4fe1\u606f\u8868")
@EnableEntityEvent
public class NetworkConfigEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column
    @NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u540d\u79f0")
    @Generated
    private @NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String name;
    @Column
    @Schema(description="\u8bf4\u660e")
    @Generated
    private String description;
    @Schema(description="\u7ec4\u4ef6\u7c7b\u578b")
    @Column(nullable=false)
    @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    @Generated
    private @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String type;
    @Column(nullable=false)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @DefaultValue(value="enabled")
    @Schema(description="\u72b6\u6001")
    @Generated
    private NetworkConfigState state;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    @Generated
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    @Generated
    private Long createTime;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @Schema(description="\u914d\u7f6e(\u6839\u636e\u7c7b\u578b\u4e0d\u540c\u800c\u4e0d\u540c)")
    @Generated
    private Map<String, Object> configuration;
    @Column
    @DefaultValue(value="true")
    @Schema(description="\u96c6\u7fa4\u662f\u5426\u5171\u4eab\u914d\u7f6e")
    @Generated
    private Boolean shareCluster;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @Schema(description="\u96c6\u7fa4\u914d\u7f6e")
    @Generated
    private List<Configuration> cluster;

    public Optional<Map<String, Object>> getConfig(String serverId) {
        if (Boolean.FALSE.equals(this.shareCluster) && CollectionUtils.isNotEmpty(this.cluster)) {
            return this.cluster.stream().filter(conf -> serverId.equals(((Configuration)conf).serverId)).findAny().map(Configuration::getConfiguration);
        }
        return Optional.ofNullable(this.configuration);
    }

    public NetworkType lookupNetworkType() {
        return NetworkType.lookup((String)this.type).orElseGet(() -> NetworkType.of((String)this.type));
    }

    public NetworkType getTypeObject() {
        return this.lookupNetworkType();
    }

    public List<NetworkProperties> toNetworkPropertiesList() {
        if (Boolean.FALSE.equals(this.shareCluster) && this.cluster != null) {
            return this.cluster.stream().map(conf -> this.toNetworkProperties(((Configuration)conf).configuration)).collect(Collectors.toList());
        }
        return Collections.singletonList(this.toNetworkProperties(this.configuration));
    }

    public NetworkProperties toNetworkProperties(Map<String, Object> conf) {
        NetworkProperties properties = new NetworkProperties();
        properties.setConfigurations(conf);
        properties.setEnabled(this.state == NetworkConfigState.enabled);
        properties.setId((String)this.getId());
        properties.setType(this.getType());
        properties.setName(this.name);
        return properties;
    }

    public NetworkProperties toNetworkProperties() {
        return this.toNetworkProperties(this.configuration);
    }

    @NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String getType() {
        return this.type;
    }

    public NetworkConfigState getState() {
        return this.state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Boolean getShareCluster() {
        return this.shareCluster;
    }

    public List<Configuration> getCluster() {
        return this.cluster;
    }

    public void setName(@NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(@NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String type) {
        this.type = type;
    }

    public void setState(NetworkConfigState state) {
        this.state = state;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setShareCluster(Boolean shareCluster) {
        this.shareCluster = shareCluster;
    }

    public void setCluster(List<Configuration> cluster) {
        this.cluster = cluster;
    }

    @Generated
    public static class Configuration
    implements Serializable {
        private String serverId;
        private Map<String, Object> configuration;

        public String getServerId() {
            return this.serverId;
        }

        public Map<String, Object> getConfiguration() {
            return this.configuration;
        }

        public void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public void setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
        }
    }
}

