/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.network.manager.enums.CertificateFormat;
import org.jetlinks.community.network.manager.enums.CertificateMode;
import org.jetlinks.community.network.manager.enums.CertificateType;
import org.jetlinks.community.network.security.DefaultCertificate;
import org.springframework.util.Assert;

@Table(name="certificate_info")
@Comment(value="\u8bc1\u4e66\u4fe1\u606f\u8868")
@EnableEntityEvent
public class CertificateEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column
    @Schema(description="\u8bc1\u4e66\u540d\u79f0")
    private String name;
    @Column(length=16)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u8bc1\u4e66\u7c7b\u578b")
    @DefaultValue(value="common")
    @NotNull(groups={CreateGroup.class})
    private CertificateType type;
    @Column(length=16)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u8bc1\u4e66\u683c\u5f0f")
    @DefaultValue(value="PEM")
    @NotNull(groups={CreateGroup.class})
    private CertificateFormat format;
    @Column(length=16)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @Schema(description="\u8bc1\u4e66\u6a21\u5f0f,Server or Client")
    @DefaultValue(value="server")
    @NotNull(groups={CreateGroup.class})
    private CertificateMode mode;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB)
    @JsonCodec
    @Schema(description="\u8bc1\u4e66\u914d\u7f6e")
    @NotNull(groups={CreateGroup.class})
    private CertificateConfig configs;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB)
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;

    public void tryValidate(Class<?> ... groups) {
        super.tryValidate((Class[])groups);
        if (groups.length == 0 || groups[0] == CreateGroup.class) {
            this.validate();
        }
    }

    public void validate() {
        Assert.notNull((Object)this.configs, (String)"error.cert_configs_can_not_be_null");
        if (this.format == CertificateFormat.PEM) {
            if (this.mode == CertificateMode.server) {
                Assert.hasText((String)this.configs.getKey(), (String)"error.pem_key_can_not_be_empty");
                Assert.hasText((String)this.configs.getCert(), (String)"error.pem_cert_can_not_be_empty");
            } else if (this.mode == CertificateMode.client) {
                Assert.hasText((String)this.configs.getTrust(), (String)"error.pem_trust_can_not_be_empty");
            }
        }
        this.format.init(new DefaultCertificate((String)this.getId(), this.getName()), this.configs);
    }

    public String getName() {
        return this.name;
    }

    @NotNull(groups={CreateGroup.class})
    public CertificateType getType() {
        return this.type;
    }

    @NotNull(groups={CreateGroup.class})
    public CertificateFormat getFormat() {
        return this.format;
    }

    @NotNull(groups={CreateGroup.class})
    public CertificateMode getMode() {
        return this.mode;
    }

    @NotNull(groups={CreateGroup.class})
    public CertificateConfig getConfigs() {
        return this.configs;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(@NotNull(groups={CreateGroup.class}) CertificateType type) {
        this.type = type;
    }

    public void setFormat(@NotNull(groups={CreateGroup.class}) CertificateFormat format) {
        this.format = format;
    }

    public void setMode(@NotNull(groups={CreateGroup.class}) CertificateMode mode) {
        this.mode = mode;
    }

    public void setConfigs(@NotNull(groups={CreateGroup.class}) CertificateConfig configs) {
        this.configs = configs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public static class CertificateConfig {
        @Schema(description="PEM:\u79c1\u94a5\u5185\u5bb9")
        private String key;
        @Schema(description="PEM:\u8bc1\u4e66\u5185\u5bb9")
        private String cert;
        @Schema(description="PEM:\u4fe1\u4efb\u8bc1\u4e66,\u7528\u4e8e\u5ba2\u6237\u7aef\u6a21\u5f0f")
        private String trust;
        @Schema(description="\u8bc1\u4e66\u5e93\u5185\u5bb9(base64)", hidden=true)
        private String keystoreBase64;
        @Schema(description="\u4fe1\u4efb\u5e93\u5185\u5bb9(base64)", hidden=true)
        private String trustKeyStoreBase64;
        @Schema(description="\u8bc1\u4e66\u5bc6\u7801", hidden=true)
        private String keystorePwd;
        @Schema(description="\u4fe1\u4efb\u5e93\u5bc6\u7801", hidden=true)
        private String trustKeyStorePwd;

        public String getKey() {
            return this.key;
        }

        public String getCert() {
            return this.cert;
        }

        public String getTrust() {
            return this.trust;
        }

        public String getKeystoreBase64() {
            return this.keystoreBase64;
        }

        public String getTrustKeyStoreBase64() {
            return this.trustKeyStoreBase64;
        }

        public String getKeystorePwd() {
            return this.keystorePwd;
        }

        public String getTrustKeyStorePwd() {
            return this.trustKeyStorePwd;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCert(String cert) {
            this.cert = cert;
        }

        public void setTrust(String trust) {
            this.trust = trust;
        }

        public void setKeystoreBase64(String keystoreBase64) {
            this.keystoreBase64 = keystoreBase64;
        }

        public void setTrustKeyStoreBase64(String trustKeyStoreBase64) {
            this.trustKeyStoreBase64 = trustKeyStoreBase64;
        }

        public void setKeystorePwd(String keystorePwd) {
            this.keystorePwd = keystorePwd;
        }

        public void setTrustKeyStorePwd(String trustKeyStorePwd) {
            this.trustKeyStorePwd = trustKeyStorePwd;
        }
    }
}

