/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.debug;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.trace.DeviceTracer;
import org.jetlinks.core.trace.ProtocolTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.trace.data.SpanDataInfo;
import org.jetlinks.core.utils.TopicUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DeviceDebugSubscriptionProvider
implements SubscriptionProvider {
    private static final Logger log = LoggerFactory.getLogger(DeviceDebugSubscriptionProvider.class);
    private final EventBus eventBus;
    private final DeviceRegistry registry;

    public String id() {
        return "device-debug";
    }

    public String name() {
        return "\u8bbe\u5907\u8bca\u65ad";
    }

    public String[] getTopicPattern() {
        return new String[]{"/debug/device/*/trace"};
    }

    public Flux<?> subscribe(SubscribeRequest request) {
        String deviceId = (String)TopicUtils.getPathVariables((String)"/debug/device/{deviceId}/trace", (String)request.getTopic()).get("deviceId");
        return this.startDebug(deviceId);
    }

    Flux<TraceData> startDebug(String deviceId) {
        if (TraceHolder.isDisabled()) {
            return Flux.just((Object)TraceData.of(TraceDataType.log, true, "0", "error", "\u94fe\u8def\u8ffd\u8e2a\u529f\u80fd\u5df2\u7981\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458.", System.currentTimeMillis(), System.currentTimeMillis()));
        }
        return Flux.merge((Publisher[])new Publisher[]{this.getTraceData(DeviceTracer.SpanName.operation((String)deviceId, (String)"*")).flatMap(this::convertDeviceTrace), this.registry.getDevice(deviceId).flatMap(device -> device.getProtocol().map(pro -> ProtocolTracer.SpanName.operation((String)pro.getId(), (String)"*"))).flatMapMany(this::getTraceData).flatMap(this::convertProtocolTrace)});
    }

    private Mono<TraceData> convertProtocolTrace(SpanDataInfo traceData) {
        String errorInfo = traceData.getEvent("exception").flatMap(event -> event.getAttribute(SemanticAttributes.EXCEPTION_STACKTRACE)).orElse(null);
        String operation = traceData.getName().substring(traceData.getName().lastIndexOf("/") + 1);
        if (StringUtils.hasText((String)errorInfo)) {
            return Mono.just((Object)TraceData.of(TraceDataType.log, true, traceData.getTraceId(), operation, this.getDeviceTraceDetail(traceData), traceData.getStartWithNanos() / 1000L / 1000L, traceData.getStartWithNanos() / 1000L / 1000L));
        }
        return Mono.empty();
    }

    private boolean hasError(SpanDataInfo data) {
        return data.getEvent("exception").isPresent();
    }

    private Object getDeviceTraceDetail(SpanDataInfo data) {
        String message = data.getAttribute(DeviceTracer.SpanKey.message).orElse(null);
        String response = data.getAttribute(DeviceTracer.SpanKey.response).orElse(null);
        if (StringUtils.hasText((String)message)) {
            if (StringUtils.hasText((String)response)) {
                return String.join((CharSequence)"\n\n", response);
            }
            return message;
        }
        if (StringUtils.hasText((String)response)) {
            return response;
        }
        String errorInfo = data.getEvent("exception").flatMap(event -> event.getAttribute(SemanticAttributes.EXCEPTION_STACKTRACE)).orElse(null);
        if (StringUtils.hasText((String)errorInfo)) {
            return errorInfo;
        }
        return JSON.toJSONString((Object)data.getAttributes(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    private Mono<TraceData> convertDeviceTrace(SpanDataInfo traceData) {
        String name = traceData.getName();
        String operation = name.substring(name.lastIndexOf("/") + 1);
        return Mono.just((Object)TraceData.of(TraceDataType.data, this.hasError(traceData), traceData.getTraceId(), operation, this.getDeviceTraceDetail(traceData), traceData.getStartWithNanos() / 1000L / 1000L, traceData.getStartWithNanos() / 1000L / 1000L));
    }

    private Flux<SpanDataInfo> getTraceData(String name) {
        Disposable disposable = this.enableSpan(name);
        return this.eventBus.subscribe(Subscription.builder().subscriberId("device_debug_tracer").topics(new String[]{"/trace/*" + name}).broker().local().build(), SpanDataInfo.class).doFinally(s -> disposable.dispose());
    }

    private Disposable enableSpan(String name) {
        Disposable.Composite disposable = Disposables.composite();
        String id = (String)IDGenerator.UUID.generate();
        this.eventBus.publish("/_sys/_trace/opt", (Object)new TraceOpt(id, name, true)).subscribe();
        disposable.add(() -> this.eventBus.publish("/_sys/_trace/opt", (Object)new TraceOpt(id, name, false)).subscribe());
        return disposable;
    }

    @Subscribe(value={"/_sys/_trace/opt"}, features={Subscription.Feature.broker, Subscription.Feature.local})
    public Mono<Void> handleTraceEnable(TraceOpt opt) {
        if (opt.enable) {
            log.debug("enable trace {} id:{}", (Object)opt.span, (Object)opt.id);
            TraceHolder.enable((String)opt.span, (String)opt.id);
        } else {
            log.debug("remove trace {} id:{}", (Object)opt.span, (Object)opt.id);
            TraceHolder.removeEnabled((String)opt.span, (String)opt.id);
        }
        return Mono.empty();
    }

    public DeviceDebugSubscriptionProvider(EventBus eventBus, DeviceRegistry registry) {
        this.eventBus = eventBus;
        this.registry = registry;
    }

    public static class TraceData
    implements Serializable {
        static Set<String> downstreamOperation = new HashSet<String>(Arrays.asList("downstream", "encode", "request"));
        private static final long serialVersionUID = 1L;
        private TraceDataType type;
        private boolean error;
        private String traceId;
        private String operation;
        private Object detail;
        private long startTime;
        private long endTime;

        public boolean isUpstream() {
            return !this.isDownstream();
        }

        public boolean isDownstream() {
            return this.operation != null && downstreamOperation.contains(this.operation);
        }

        public void setType(TraceDataType type) {
            this.type = type;
        }

        public void setError(boolean error) {
            this.error = error;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void setDetail(Object detail) {
            this.detail = detail;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public TraceDataType getType() {
            return this.type;
        }

        public boolean isError() {
            return this.error;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getOperation() {
            return this.operation;
        }

        public Object getDetail() {
            return this.detail;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        private TraceData(TraceDataType type, boolean error, String traceId, String operation, Object detail, long startTime, long endTime) {
            this.type = type;
            this.error = error;
            this.traceId = traceId;
            this.operation = operation;
            this.detail = detail;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public static TraceData of(TraceDataType type, boolean error, String traceId, String operation, Object detail, long startTime, long endTime) {
            return new TraceData(type, error, traceId, operation, detail, startTime, endTime);
        }

        public TraceData() {
        }

        public String toString() {
            return "DeviceDebugSubscriptionProvider.TraceData(type=" + (Object)((Object)this.getType()) + ", error=" + this.isError() + ", traceId=" + this.getTraceId() + ", operation=" + this.getOperation() + ", detail=" + this.getDetail() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }

    public static enum TraceDataType {
        data,
        log;

    }

    public static class TraceOpt {
        private String id;
        private String span;
        private boolean enable;

        public String getId() {
            return this.id;
        }

        public String getSpan() {
            return this.span;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setSpan(String span) {
            this.span = span;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public TraceOpt(String id, String span, boolean enable) {
            this.id = id;
            this.span = span;
            this.enable = enable;
        }

        public TraceOpt() {
        }
    }
}

