/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import java.util.Optional;
import org.jetlinks.community.network.ClientNetworkConfig;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.ServerNetworkConfig;
import org.jetlinks.community.network.channel.Address;
import org.jetlinks.community.network.channel.ChannelInfo;
import org.jetlinks.community.network.channel.ChannelProvider;
import org.jetlinks.community.network.manager.entity.NetworkConfigEntity;
import org.jetlinks.community.network.manager.enums.NetworkConfigState;
import org.jetlinks.community.network.manager.service.NetworkConfigService;
import org.jetlinks.core.utils.FluxUtils;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class NetworkChannelProvider
implements ChannelProvider {
    public static final String CHANNEL = "network";
    private final NetworkManager networkManager;
    private final NetworkConfigService configService;

    public String getChannel() {
        return CHANNEL;
    }

    public Mono<ChannelInfo> getChannelInfo(String channelId) {
        return this.configService.findById(channelId).flatMap(this::toChannelInfo);
    }

    public Mono<ChannelInfo> toChannelInfo(NetworkConfigEntity entity) {
        ChannelInfo info = new ChannelInfo();
        info.setId((String)entity.getId());
        info.setDescription(entity.getDescription());
        info.setName(entity.getName());
        return Mono.justOrEmpty((Optional)this.networkManager.getProvider(entity.getType())).flatMap(provider -> ((Flux)Flux.fromIterable(entity.toNetworkPropertiesList()).flatMap(arg_0 -> ((NetworkProvider)provider).createConfig(arg_0)).as(FluxUtils.safeMap(conf -> {
            if (conf instanceof ClientNetworkConfig) {
                return ((ClientNetworkConfig)conf).getRemoteAddress();
            }
            if (conf instanceof ServerNetworkConfig) {
                return ((ServerNetworkConfig)conf).getPublicAddress();
            }
            return null;
        }))).distinct().map(address -> Address.of((String)address, (byte)(entity.getState() == NetworkConfigState.enabled ? (byte)1 : (byte)-1))).collectList()).doOnNext(arg_0 -> ((ChannelInfo)info).setAddresses(arg_0)).thenReturn((Object)info);
    }

    public NetworkChannelProvider(NetworkManager networkManager, NetworkConfigService configService) {
        this.networkManager = networkManager;
        this.configService = configService;
    }
}

